/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc.filters;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.tcc.filters.MicroTxTccInterceptorService;
import com.oracle.microtx.tcc.storage.MicroTxTccThreadLocalStorageService;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.lang.invoke.MethodHandles;
import oracle.tmm.tcc.TccCoordintorClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
public class MicroTxTccFeignReqInterceptor
implements RequestInterceptor {
    static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private MicroTxTccThreadLocalStorageService threadLocalStorageService;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    @Autowired
    MicroTxTccInterceptorService microTxInterceptorService;

    public void apply(RequestTemplate request) {
        this.transactionUtils.setTxIdToThreadLocal(request);
        TccCoordintorClient tccTxn = this.threadLocalStorageService.getTCCTransaction();
        if (tccTxn != null) {
            if (MicroTxConfig.isPropagateTraceHeadersActive().booleanValue()) {
                this.microTxInterceptorService.propagateTraceHeaders(request);
            }
            this.microTxInterceptorService.propagateAuthzHeaders(request);
            LOGGER.debug("TccRequestClientFilter with tcc transaction URL: {}", (Object)tccTxn.getTransactionUrl());
            StringBuilder linkHeaderValue = new StringBuilder();
            MicroTxTccInterceptorService.buildLinkHeader(linkHeaderValue, null, tccTxn.getTransactionUrl(), "https://otmm.oracle.com/tcc-transaction");
            request.header("Link", new String[]{linkHeaderValue.toString()});
        }
        request.header("Content-Type", new String[]{"application/json"});
    }
}

