/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc.filters;

import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.tcc.filters.MicroTxTccInterceptorService;
import com.oracle.microtx.tcc.pojo.TccParticipantLinks;
import com.oracle.microtx.tcc.storage.MicroTxTccThreadLocalStorageService;
import feign.InvocationContext;
import feign.Response;
import feign.ResponseInterceptor;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.tmm.tcc.TccCoordintorClient;
import oracle.tmm.tcc.vo.TccParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
public class MicroTxTccFeignResInterceptor
implements ResponseInterceptor {
    static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private MicroTxTccThreadLocalStorageService threadLocalStorageService;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    @Autowired
    MicroTxTccInterceptorService microTxInterceptorService;

    public Object intercept(InvocationContext invocationContext, ResponseInterceptor.Chain chain) throws Exception {
        Response response = invocationContext.response();
        TccCoordintorClient tccTxn = this.threadLocalStorageService.getTCCTransaction();
        LOGGER.debug("Tcc response with tcc transaction URL: {}", (Object)tccTxn.getTransactionUrl());
        ArrayList<String> linkHeaderCtxList = new ArrayList<String>((Collection)response.headers().get("Link"));
        LOGGER.debug("Tcc response  with tcc transaction URL: {}", linkHeaderCtxList);
        List<TccParticipantLinks> participantLinks = this.microTxInterceptorService.getParticipantLinks(linkHeaderCtxList);
        for (TccParticipantLinks link : participantLinks) {
            tccTxn.addTccParticipant(new TccParticipant(link.getParticipantUri().toString(), link.getTimelimit()));
        }
        return response;
    }
}

