/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc.filters;

import com.oracle.microtx.common.AbstractMicroTxInterceptor;
import com.oracle.microtx.common.HeaderPropagation;
import com.oracle.microtx.exception.MicroTxException;
import com.oracle.microtx.tcc.pojo.TccParticipantLinks;
import com.oracle.microtx.tcc.storage.MicroTxTccThreadLocalStorageService;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.ClientRequest;

@Service
public class MicroTxTccInterceptorService
extends AbstractMicroTxInterceptor {
    @Autowired
    MicroTxTccThreadLocalStorageService microTxThreadlocalService;
    @Autowired
    HeaderPropagation headerPropagation;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Map<String, List<String>> getRequestHeaders(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), h -> Collections.list(request.getHeaders(h))));
    }

    public void logRequest(HttpServletRequest request) {
        Map<String, List<String>> headersMap = this.getRequestHeaders(request);
        this.microTxThreadlocalService.setRequestHeaders(headersMap);
    }

    public List<TccParticipantLinks> getParticipantLinks(List<String> linkheaders) {
        if (linkheaders == null) {
            throw new MicroTxException("No LinkHeader Present");
        }
        ArrayList<TccParticipantLinks> tccParticipantLinks = new ArrayList<TccParticipantLinks>();
        for (String linkString : linkheaders) {
            String[] links;
            for (String participantLinks : links = linkString.split(",")) {
                if (!participantLinks.contains("https://otmm.oracle.com/tcc-participant")) continue;
                String[] linkParts = participantLinks.split(";");
                TccParticipantLinks participant = new TccParticipantLinks();
                try {
                    URI uri = new URI(linkParts[0].substring(1, linkParts[0].length() - 1));
                    Long timeLimit = 0L;
                    for (int i = 1; i < linkParts.length; ++i) {
                        if (!linkParts[i].contains("timeLimit=")) continue;
                        int start = linkParts[i].indexOf(34) + 1;
                        int end = linkParts[i].lastIndexOf(34);
                        String numericValue = linkParts[i].substring(start, end);
                        timeLimit = Long.parseLong(numericValue);
                    }
                    participant.setParticipantUri(uri);
                    participant.setTimelimit(timeLimit);
                    tccParticipantLinks.add(participant);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to parse the link Headers");
                }
            }
        }
        return tccParticipantLinks;
    }

    public void propagateTraceHeaders(HttpRequest request) {
        if (request != null) {
            this.headerPropagation.propagateTraceHeaders(request, this.microTxThreadlocalService.getRequestHeaders());
        }
    }

    public void propagateAuthzHeaders(HttpRequest request) {
        if (request != null) {
            this.headerPropagation.propagateAuthzHeaders(request, this.microTxThreadlocalService.getRequestHeaders());
        }
    }

    public void propagateTraceHeaders(ClientRequest request, ClientRequest.Builder requestBuilder) {
        if (requestBuilder != null) {
            this.headerPropagation.propagateTraceHeaders(request, requestBuilder, this.microTxThreadlocalService.getRequestHeaders());
        }
    }

    public void propagateAuthzHeaders(ClientRequest request, ClientRequest.Builder requestBuilder) {
        if (requestBuilder != null) {
            this.headerPropagation.propagateAuthzHeaders(request, requestBuilder, this.microTxThreadlocalService.getRequestHeaders());
        }
    }

    public void propagateTraceHeaders(RequestTemplate request) {
        if (request != null) {
            this.headerPropagation.propagateTraceHeaders(request, this.microTxThreadlocalService.getRequestHeaders());
        }
    }

    public void propagateAuthzHeaders(RequestTemplate request) {
        if (request != null) {
            this.headerPropagation.propagateAuthzHeaders(request, this.microTxThreadlocalService.getRequestHeaders());
        }
    }
}

