/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc.filters;

import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.tcc.MicroTxTccCoordinatorClientService;
import com.oracle.microtx.tcc.annotation.TCC;
import com.oracle.microtx.tcc.filters.MicroTxTccInterceptorService;
import com.oracle.microtx.tcc.pojo.TransactionDetails;
import com.oracle.microtx.tcc.storage.MicroTxTccThreadLocalStorageService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
@TCC
public class MicroTxTccServerInterceptor
implements HandlerInterceptor {
    static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private MicroTxTccThreadLocalStorageService threadLocalStorageService;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    @Autowired
    MicroTxTccInterceptorService microTxTccInterceptorService;
    @Autowired
    MicroTxTccCoordinatorClientService microTxTccCoordinatorClientService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        Class controllerClass;
        this.transactionUtils.setTxIdToThreadLocal(request);
        this.microTxTccInterceptorService.logRequest(request);
        URI tccTransactionUrl = this.transactionUtils.parseLinkHeaderRelUri(request.getHeader("Link"), "https://otmm.oracle.com/tcc-transaction");
        TCC tcc = null;
        if (handler instanceof HandlerMethod && (controllerClass = (handlerMethod = (HandlerMethod)handler).getBeanType()).isAnnotationPresent(TCC.class)) {
            tcc = controllerClass.getAnnotation(TCC.class);
        }
        if (tcc == null) {
            return true;
        }
        long timeInMilliSeconds = 0L;
        timeInMilliSeconds = tcc.timeLimit() != 0L ? Duration.of(tcc.timeLimit(), tcc.timeUnit()).toMillis() : tcc.timeLimit();
        this.startTccTransaction(tccTransactionUrl, timeInMilliSeconds);
        if (this.microTxTccCoordinatorClientService == null) {
            LOGGER.error("Unable to start TccTransaction");
            return false;
        }
        this.threadLocalStorageService.setTCCTransaction(this.microTxTccCoordinatorClientService);
        return true;
    }

    private void startTccTransaction(URI transactionUrl, long timeLimit) {
        TransactionDetails transactionDetails = new TransactionDetails();
        try {
            if (transactionUrl != null) {
                transactionDetails.setTransactionDetails(transactionUrl, timeLimit);
            } else {
                transactionDetails.setTransactionDetails(timeLimit);
            }
            this.threadLocalStorageService.setTCCTransactionDetails(transactionDetails);
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while initializing TCC transaction: {}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        try {
            if (this.threadLocalStorageService.getTCCTransaction() != null) {
                LOGGER.debug("cleanup tcc context data in resp filter");
                LOGGER.debug("TccTransactionResponseFilter Response Status : {}", (Object)response.getStatus());
            }
            this.threadLocalStorageService.remove();
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while closing tcc response context: {}", (Throwable)e);
        }
        finally {
            this.threadLocalStorageService.removeTransactionId();
        }
    }
}

