/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc.filters;

import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.tcc.filters.MicroTxTccInterceptorService;
import com.oracle.microtx.tcc.storage.MicroTxTccThreadLocalStorageService;
import java.lang.invoke.MethodHandles;
import oracle.tmm.tcc.TccCoordintorClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class TccResponseBodyFilter<T>
implements ResponseBodyAdvice<T> {
    static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private MicroTxTccThreadLocalStorageService threadLocalStorageService;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    @Autowired
    MicroTxTccInterceptorService microTxTccInterceptorService;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public T beforeBodyWrite(T body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        this.transactionUtils.setTxIdToThreadLocal((HttpRequest)request);
        TccCoordintorClient tccTransaction = this.threadLocalStorageService.getTCCTransaction();
        if (tccTransaction == null) {
            return body;
        }
        String linkHeaderValue = this.microTxTccInterceptorService.buildTccParticipantsAsLinkHeader(tccTransaction);
        if (linkHeaderValue.length() > 0) {
            response.getHeaders().add("Link", linkHeaderValue);
        }
        return body;
    }
}

