/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc.pojo;

import com.oracle.microtx.common.MicroTxConfig;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import oracle.tmm.tcc.vo.TccParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionDetails {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public String txnId;
    public String txnUrl;
    public List<TccParticipant> tccParticipants;
    public long timeLimit;

    public String getTxnId() {
        return this.txnId;
    }

    public void setTxnId(String txnId) {
        this.txnId = txnId;
    }

    public String getTxnUrl() {
        return this.txnUrl;
    }

    public void setTxnUrl(String txnUrl) {
        this.txnUrl = txnUrl;
    }

    public void setTccParticipants(List<TccParticipant> tccParticipants) {
        this.tccParticipants = tccParticipants;
    }

    public String getTransactionUrl() {
        return this.txnUrl;
    }

    public String getTransactionId() {
        return this.txnId;
    }

    public void addTccParticipant(TccParticipant tccParticipants) {
        this.tccParticipants.add(tccParticipants);
    }

    public List<TccParticipant> getTccParticipants() {
        return this.tccParticipants;
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimit = timeLimit;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTransactionDetails(URI txnUri, long timeLimit) {
        String path = txnUri.getPath();
        String trxId = path.substring(path.lastIndexOf(47) + 1);
        this.setTimeLimit(timeLimit);
        this.setTxnId(trxId);
        this.setTxnUrl(txnUri.toString());
        this.setTccParticipants(new ArrayList<TccParticipant>());
        LOGGER.info("Transaction initialized with txtId:{}, txnUrl:{}", (Object)this.txnId, (Object)this.txnUrl);
    }

    public void setTransactionDetails(long timeLimit) {
        this.setTxnId(UUID.randomUUID().toString());
        this.setTxnUrl(MicroTxConfig.coordinatorUrl + "/tcc-transaction/" + this.getTxnId());
        this.setTccParticipants(new ArrayList<TccParticipant>());
        this.setTimeLimit(timeLimit);
    }
}

