/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.tcc.storage;

import com.oracle.microtx.tcc.TccStorage;
import com.oracle.microtx.tcc.pojo.TransactionDetails;
import java.util.List;
import java.util.Map;
import oracle.tmm.tcc.TccCoordintorClient;
import org.slf4j.MDC;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
public class MicroTxTccThreadLocalStorageService
implements TccStorage {
    private static ThreadLocal<Map<String, List<String>>> transactionRequestHeadersThreadLocal = new ThreadLocal();
    private static ThreadLocal<TccCoordintorClient> threadLocal = new ThreadLocal();
    private static ThreadLocal<TransactionDetails> transactionDetailsThreadLocal = new ThreadLocal();

    public void setRequestHeaders(Map<String, List<String>> headers) {
        transactionRequestHeadersThreadLocal.set(headers);
    }

    public Map<String, List<String>> getRequestHeaders() {
        return transactionRequestHeadersThreadLocal.get();
    }

    public static TccCoordintorClient get() {
        return threadLocal.get();
    }

    public void remove() {
        threadLocal.remove();
        transactionDetailsThreadLocal.remove();
    }

    public static String getThreadLocalTxnId() {
        String id = null;
        TccCoordintorClient txn = MicroTxTccThreadLocalStorageService.get();
        if (txn != null) {
            id = txn.getTransactionId();
        }
        return id;
    }

    @Override
    public void setTCCTransaction(TccCoordintorClient tccTransaction) {
        threadLocal.set(tccTransaction);
    }

    @Override
    public TccCoordintorClient getTCCTransaction() {
        return threadLocal.get();
    }

    public void setTCCTransactionDetails(TransactionDetails transactionDetails) {
        transactionDetailsThreadLocal.set(transactionDetails);
    }

    public TransactionDetails getTCCTransactionDetails() {
        return transactionDetailsThreadLocal.get();
    }

    public void removeTransactionId() {
        MDC.remove((String)"microtx-txnId");
    }
}

