/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.xa.coordinator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.exception.MicroTxException;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.coordinator.CoordinatorClient;
import com.oracle.microtx.xa.coordinator.CoordinatorEnlistResponse;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.tmm.common.BadRequestException;
import oracle.tmm.common.TooManyRequestsException;
import oracle.tmm.jta.CoordinatorPayloadBuilder;
import oracle.tmm.jta.EnlistInfo;
import oracle.tmm.jta.TrmTCSResponse;
import oracle.tmm.jta.exceptions.TrmPromoteException;
import oracle.tmm.jta.pojo.TcsEnlistRequestPayload;
import oracle.tmm.jta.pojo.TcsEnlistedResponsePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class MicroTxCoordinatorClient
implements CoordinatorClient {
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    @Autowired
    @Qualifier(value="MicroTxXaRestTemplate")
    RestTemplate restTemplate;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String EMPTY_JSON = "{ }";

    @Override
    public CoordinatorEnlistResponse begin(String gtrid, int timeout, Map<String, Object> insProperties) throws SystemException {
        LOGGER.debug("XA begin called with timeout(ms):{}", (Object)timeout);
        ObjectMapper objectMapper = new ObjectMapper();
        EnlistInfo data = new EnlistInfo();
        data.setTimeout(timeout);
        data.setGtrid(gtrid);
        data.setInsProperties(insProperties);
        String txnUrl = MicroTxConfig.getCoordinatorUrl() + "/xa-transaction";
        HttpHeaders headers = new HttpHeaders();
        headers.set("oracle-tmm-txn-id", gtrid);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity enlistEntity = new HttpEntity((Object)data, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(txnUrl, HttpMethod.POST, enlistEntity, String.class, new Object[0]);
            HttpStatus status = HttpStatus.resolve((int)response.getStatusCode().value());
            this.transactionUtils.setTxIdToThreadLocal(gtrid);
            TcsEnlistedResponsePayload xaTransactionResponse = null;
            try {
                xaTransactionResponse = (TcsEnlistedResponsePayload)objectMapper.readValue((String)response.getBody(), TcsEnlistedResponsePayload.class);
            }
            catch (JsonProcessingException e) {
                throw new MicroTxException(e.getMessage(), e);
            }
            LOGGER.info("begin response status code from TCS: {}", (Object)status);
            LOGGER.debug("begin response from TCS: {}", (Object)xaTransactionResponse);
            CoordinatorEnlistResponse enlistResponse = new CoordinatorEnlistResponse();
            enlistResponse.setTcsEnlistedResponsePayload(xaTransactionResponse);
            enlistResponse.setHttpStatusCode(response.getStatusCode().value());
            List txnTokenHeaders = response.getHeaders().get((Object)"oracle-tmm-tx-token");
            enlistResponse.setTransactionTokenHeader(txnTokenHeaders);
            return enlistResponse;
        }
        catch (HttpStatusCodeException e) {
            String responseAsString = e.getResponseBodyAsString();
            LOGGER.error("XA txn begin failed with response status code from TCS: {}\"", (Object)e.getStatusCode());
            LOGGER.error("XA txn begin failed with response from TCS: {}", (Object)responseAsString);
            if (e.getStatusCode().equals(HttpStatus.TOO_MANY_REQUESTS)) {
                throw new TooManyRequestsException(responseAsString);
            }
            if (e.getStatusCode().equals(HttpStatus.BAD_REQUEST)) {
                throw new BadRequestException(responseAsString);
            }
            throw new SystemException(responseAsString + " " + e.getStatusCode());
        }
    }

    @Override
    public CoordinatorEnlistResponse beginWithEnlist(String gtrid, int timeout, Map<String, Object> insProperties, String rmid, String requestId, String instanceName) throws IOException {
        LOGGER.debug("XA begin(timeout(ms):{}) with enlist called with rmid: {}, requestId: {}", new Object[]{timeout, rmid, requestId});
        ObjectMapper objectMapper = new ObjectMapper();
        EnlistInfo enlistTransactionEntity = new EnlistInfo();
        enlistTransactionEntity.setTimeout(timeout);
        enlistTransactionEntity.setGtrid(gtrid);
        enlistTransactionEntity.setInsProperties(insProperties);
        enlistTransactionEntity.setCallbackUrl(MicroTxConfig.participantCallBackUrl);
        CoordinatorEnlistResponse enlistResponse = new CoordinatorEnlistResponse();
        String transactionUrl = MicroTxConfig.coordinatorUrl + "/xa-transaction";
        TcsEnlistRequestPayload coordinatorEnlistPayload = CoordinatorPayloadBuilder.buildEnlistPayload(MicroTxConfig.participantCallBackUrl, rmid, instanceName);
        enlistTransactionEntity.setResourceManagers(coordinatorEnlistPayload.resourceManagers);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.set("oracle-tmm-txn-id", gtrid);
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity enlistEntity = new HttpEntity((Object)enlistTransactionEntity, (MultiValueMap)headers);
            try {
                ResponseEntity response = this.restTemplate.exchange(transactionUrl, HttpMethod.POST, enlistEntity, String.class, new Object[0]);
                HttpStatus respStatus = HttpStatus.resolve((int)response.getStatusCode().value());
                String responseAsString = (String)response.getBody();
                TcsEnlistedResponsePayload tcsEnlistedResponsePayload = (TcsEnlistedResponsePayload)objectMapper.readValue(responseAsString, TcsEnlistedResponsePayload.class);
                LOGGER.debug("Begin with enlist response: {}", (Object)tcsEnlistedResponsePayload.toString());
                enlistResponse.setTcsEnlistedResponsePayload(tcsEnlistedResponsePayload);
                enlistResponse.setHttpStatusCode(respStatus.value());
                List txnTokenHeaders = response.getHeaders().get((Object)"oracle-tmm-tx-token");
                enlistResponse.setTransactionTokenHeader(txnTokenHeaders);
            }
            catch (HttpStatusCodeException e) {
                String responseAsString = e.getResponseBodyAsString();
                LOGGER.error("XA txn begin failed with response from TCS: {}  status: {}", (Object)responseAsString, (Object)e.getStatusCode());
                if (e.getStatusCode().equals(HttpStatus.TOO_MANY_REQUESTS)) {
                    throw new TooManyRequestsException(responseAsString);
                }
                if (e.getStatusCode().equals(HttpStatus.BAD_REQUEST)) {
                    throw new BadRequestException(responseAsString);
                }
                throw new TrmPromoteException(responseAsString + " " + e.getStatusCode());
            }
        }
        catch (JsonProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                throw new IOException("Not able to reach the MicroTx Coordinator instance with the provided url " + MicroTxConfig.coordinatorUrl, e);
            }
            throw new IOException(e.getMessage(), e);
        }
        catch (Exception e) {
            LOGGER.error("Enlist failed", (Throwable)e);
            throw new IOException("Enlist Failed " + e.getMessage(), e);
        }
        return enlistResponse;
    }

    @Override
    public CoordinatorEnlistResponse enlist(String rmid, String requestId, String transactionUrl, String rmInstanceName) throws IOException {
        LOGGER.debug("XA enlist called with rmid: {}, requestId: {}", (Object)rmid, (Object)requestId);
        ObjectMapper objectMapper = new ObjectMapper();
        String gtrid = transactionUrl.substring(transactionUrl.lastIndexOf(47) + 1);
        TcsEnlistRequestPayload enlistTransactionEntity = CoordinatorPayloadBuilder.buildEnlistPayload(MicroTxConfig.getParticipantCallBackUrl(), rmid, rmInstanceName);
        HttpHeaders headers = new HttpHeaders();
        headers.set("oracle-tmm-txn-id", gtrid);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity enlistEntity = new HttpEntity((Object)enlistTransactionEntity, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(transactionUrl, HttpMethod.POST, enlistEntity, String.class, new Object[0]);
            TcsEnlistedResponsePayload tcsEnlistedResponsePayload = (TcsEnlistedResponsePayload)objectMapper.readValue((String)response.getBody(), TcsEnlistedResponsePayload.class);
            LOGGER.debug("XA Enlist response: {} : {}", (Object)response.getStatusCode().value(), (Object)tcsEnlistedResponsePayload.toString());
            CoordinatorEnlistResponse enlistResponse = new CoordinatorEnlistResponse();
            enlistResponse.setTcsEnlistedResponsePayload(tcsEnlistedResponsePayload);
            enlistResponse.setHttpStatusCode(response.getStatusCode().value());
            return enlistResponse;
        }
        catch (HttpStatusCodeException e) {
            throw new IOException("Enlist Failed " + transactionUrl + " Error: " + e.getResponseBodyAsString() + " " + e.getStatusCode().value());
        }
    }

    @Override
    public void commit(String gtrid, String transactionUrl) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        LOGGER.debug("XA commit called with transactionUrl: {}", (Object)transactionUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.set("oracle-tmm-txn-id", gtrid);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity commitEntity = new HttpEntity((Object)EMPTY_JSON, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(transactionUrl, HttpMethod.PUT, commitEntity, String.class, new Object[0]);
            LOGGER.info("XA Commit response status code : {}", (Object)response.getStatusCode().value());
            LOGGER.debug("XA Commit response: {}", response.getBody());
        }
        catch (HttpStatusCodeException e) {
            LOGGER.error("XA Commit failed with response status code : {}", (Object)e.getStatusCode().value());
            LOGGER.error("XA Commit failed with response: {}", (Object)e.getResponseBodyAsString());
            Exception ex = TrmTCSResponse.getException(e.getResponseBodyAsString());
            throw new MicroTxException(ex.getMessage(), ex);
        }
        finally {
            this.microTxXaTxnStoreService.clear();
        }
    }

    @Override
    public void rollback(String gtrid, String transactionUrl) throws IllegalStateException, SecurityException, SystemException {
        LOGGER.debug("XA rollback called with transactionUrl: {}", (Object)transactionUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.set("oracle-tmm-txn-id", gtrid);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity rollbackEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(transactionUrl, HttpMethod.DELETE, rollbackEntity, String.class, new Object[0]);
            HttpStatus status = HttpStatus.resolve((int)response.getStatusCode().value());
            LOGGER.info("XA rollback response status code: {}", (Object)status);
            LOGGER.debug("XA rollback response: {}", response.getBody());
        }
        catch (HttpStatusCodeException e) {
            LOGGER.error("XA rollback failed with response status code: {}", (Object)e.getStatusCode().value());
            LOGGER.error("XA rollback failed with response: {}", (Object)e.getResponseBodyAsString());
            throw new SystemException(e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
        finally {
            this.microTxXaTxnStoreService.clear();
        }
    }

    @Override
    public int getStatus(String gtrid, String transactionUrl) throws SystemException {
        LOGGER.debug("XA getStatus called with transactionUrl: {}", (Object)transactionUrl);
        ObjectMapper objectMapper = new ObjectMapper();
        HttpHeaders headers = new HttpHeaders();
        headers.set("oracle-tmm-txn-id", gtrid);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity getStatusEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(transactionUrl, HttpMethod.GET, getStatusEntity, String.class, new Object[0]);
            HttpStatus httpStatus = HttpStatus.resolve((int)response.getStatusCode().value());
            LOGGER.info("XA getStatus response status code: {}", (Object)httpStatus);
            LOGGER.info("XA getStatus response: {}", response.getBody());
            String status = null;
            JsonNode node = objectMapper.readTree((String)response.getBody());
            switch (status = node.get("status").asText()) {
                case "Created": {
                    return 0;
                }
                case "MarkedRollback": {
                    return 1;
                }
                case "Preparing": {
                    return 7;
                }
                case "Prepared": {
                    return 2;
                }
                case "Committing": {
                    return 8;
                }
                case "Committed": {
                    return 3;
                }
                case "Rollingback": {
                    return 9;
                }
                case "Rolledback": {
                    return 4;
                }
                case "HeuristicallyCompleted": {
                    return 5;
                }
            }
            return 5;
        }
        catch (HttpStatusCodeException e) {
            LOGGER.error("XA getStatus failed with response status code: {}", (Object)e.getStatusCode().value());
            LOGGER.error("XA getStatus failed with response: {}", (Object)e.getResponseBodyAsString());
            throw new SystemException(e.getResponseBodyAsString());
        }
        catch (Exception e) {
            throw new SystemException();
        }
    }

    public ResponseEntity<String> enlistNonXA(String transactionUrl, String gtrid, String rmid, boolean isLLRBranch, boolean isLRCBranch) {
        TcsEnlistRequestPayload enlistTransactionEntity = new TcsEnlistRequestPayload();
        enlistTransactionEntity.setCallbackUrl(MicroTxConfig.getParticipantCallBackUrl());
        enlistTransactionEntity.resourceManagers = new ArrayList<TcsEnlistRequestPayload.ResourceManager>();
        TcsEnlistRequestPayload.ResourceManager participantsEntity = new TcsEnlistRequestPayload.ResourceManager();
        participantsEntity.setResourceManagerId(rmid);
        if (isLLRBranch) {
            participantsEntity.setLlrSupport(true);
        }
        if (isLRCBranch) {
            participantsEntity.setLrcSupport(true);
        }
        enlistTransactionEntity.resourceManagers.add(participantsEntity);
        HttpHeaders headers = new HttpHeaders();
        headers.set("oracle-tmm-txn-id", gtrid);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity enlistEntity = new HttpEntity((Object)EMPTY_JSON, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(transactionUrl, HttpMethod.POST, enlistEntity, String.class, new Object[0]);
            return response;
        }
        catch (HttpStatusCodeException e) {
            LOGGER.error("Non XA enlistment failed , enlist response {} , status code {}", (Object)e.getResponseBodyAsString(), (Object)e.getStatusCode().value());
            return new ResponseEntity((Object)e.getResponseBodyAsString(), (MultiValueMap)e.getResponseHeaders(), e.getStatusCode());
        }
    }

    @Override
    public void registerSync(String gtrid, String callbackUri) throws Exception {
        try {
            String transactionUrl = MicroTxConfig.getCoordinatorUrl() + "/" + "xa-transaction" + "/" + gtrid + "/registersync";
            String callbackLink = String.format("<%s>; rel=\"%s\"", MicroTxConfig.getParticipantCallBackUrl() + callbackUri, "https://otmm.oracle.com/xa-transaction/registersync");
            HttpHeaders headers = new HttpHeaders();
            headers.set("oracle-tmm-txn-id", gtrid);
            headers.set("Link", callbackLink);
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity registerEntity = new HttpEntity((Object)EMPTY_JSON, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(transactionUrl, HttpMethod.POST, registerEntity, String.class, new Object[0]);
            LOGGER.info("registerSync response: {}", response.getBody());
            if (response.getStatusCode().value() != HttpStatus.OK.value()) {
                throw new IOException("registerSync failed : " + response.getStatusCode().value() + " : " + (String)response.getBody());
            }
            LOGGER.info("registerSync status: {}", (Object)response.getStatusCode().value());
        }
        catch (HttpStatusCodeException e) {
            LOGGER.error("registerSync failed , TCS response: {}", (Object)e.getResponseBodyAsString());
            throw new IOException("registerSync failed : " + e.getStatusCode().value() + " : " + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            LOGGER.error("exception while executing registerSync: {}", (Object)e.getMessage());
            LOGGER.trace("registerSync failed", (Throwable)e);
            throw e;
        }
    }
}

