/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.xa.mybatis;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.result.DefaultMapResultHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.ParamNameResolver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class MicroTxSqlSession
implements SqlSession {
    private final Configuration configuration;
    private final Executor executor;
    private final boolean autoCommit;
    private boolean dirty;
    private List<Cursor<?>> cursorList;

    public MicroTxSqlSession(Configuration configuration, Executor executor, boolean autoCommit) {
        this.configuration = configuration;
        this.executor = executor;
        this.dirty = false;
        this.autoCommit = autoCommit;
    }

    public MicroTxSqlSession(Configuration configuration, Executor executor) {
        this(configuration, executor, false);
    }

    public <T> T selectOne(String statement) {
        return this.selectOne(statement, null);
    }

    public <T> T selectOne(String statement, Object parameter) {
        List list = this.selectList(statement, parameter);
        if (list.size() == 1) {
            return (T)list.get(0);
        }
        if (list.size() > 1) {
            throw new TooManyResultsException("Expected one result (or null) to be returned by selectOne(), but found: " + list.size());
        }
        return null;
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return this.selectMap(statement, null, mapKey, RowBounds.DEFAULT);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.selectMap(statement, parameter, mapKey, RowBounds.DEFAULT);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        List list = this.selectList(statement, parameter, rowBounds);
        DefaultMapResultHandler mapResultHandler = new DefaultMapResultHandler(mapKey, this.configuration.getObjectFactory(), this.configuration.getObjectWrapperFactory(), this.configuration.getReflectorFactory());
        DefaultResultContext context = new DefaultResultContext();
        for (Object o : list) {
            context.nextResultObject(o);
            mapResultHandler.handleResult((ResultContext)context);
        }
        return mapResultHandler.getMappedResults();
    }

    public <T> Cursor<T> selectCursor(String statement) {
        return this.selectCursor(statement, null);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter) {
        return this.selectCursor(statement, parameter, RowBounds.DEFAULT);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter, RowBounds rowBounds) {
        try {
            MappedStatement ms = this.configuration.getMappedStatement(statement);
            this.dirty |= ms.isDirtySelect();
            Cursor cursor = this.executor.queryCursor(ms, this.wrapCollection(parameter), rowBounds);
            this.registerCursor(cursor);
            Cursor cursor2 = cursor;
            return cursor2;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)("Error querying database.  Cause: " + e), (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    public <E> List<E> selectList(String statement) {
        return this.selectList(statement, null);
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, RowBounds.DEFAULT);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.selectList(statement, parameter, rowBounds, Executor.NO_RESULT_HANDLER);
    }

    private <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        try {
            MappedStatement ms = this.configuration.getMappedStatement(statement);
            this.dirty |= ms.isDirtySelect();
            List list = this.executor.query(ms, this.wrapCollection(parameter), rowBounds, handler);
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)("Error querying database.  Cause: " + e), (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.select(statement, parameter, RowBounds.DEFAULT, handler);
    }

    public void select(String statement, ResultHandler handler) {
        this.select(statement, null, RowBounds.DEFAULT, handler);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.selectList(statement, parameter, rowBounds, handler);
    }

    public int insert(String statement) {
        return this.insert(statement, null);
    }

    public int insert(String statement, Object parameter) {
        return this.update(statement, parameter);
    }

    public int update(String statement) {
        return this.update(statement, null);
    }

    public int update(String statement, Object parameter) {
        try {
            this.dirty = true;
            MappedStatement ms = this.configuration.getMappedStatement(statement);
            int n = this.executor.update(ms, this.wrapCollection(parameter));
            return n;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)("Error updating database.  Cause: " + e), (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    public int delete(String statement) {
        return this.update(statement, null);
    }

    public int delete(String statement, Object parameter) {
        return this.update(statement, parameter);
    }

    public void commit() {
        this.commit(false);
    }

    public void commit(boolean force) {
        try {
            this.executor.commit(this.isCommitOrRollbackRequired(force));
            this.dirty = false;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)("Error committing transaction.  Cause: " + e), (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    public void rollback() {
        this.rollback(false);
    }

    public void rollback(boolean force) {
        try {
            this.executor.rollback(this.isCommitOrRollbackRequired(force));
            this.dirty = false;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)("Error rolling back transaction.  Cause: " + e), (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    public List<BatchResult> flushStatements() {
        try {
            List list = this.executor.flushStatements();
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)("Error flushing statements.  Cause: " + e), (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    public void close() {
        try {
            this.executor.close(this.isCommitOrRollbackRequired(false));
            this.closeCursors();
            this.dirty = false;
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    private void closeCursors() {
        if (this.cursorList != null && !this.cursorList.isEmpty()) {
            for (Cursor<?> cursor : this.cursorList) {
                try {
                    cursor.close();
                }
                catch (IOException e) {
                    throw ExceptionFactory.wrapException((String)("Error closing cursor.  Cause: " + e), (Exception)e);
                }
            }
            this.cursorList.clear();
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public <T> T getMapper(Class<T> type) {
        return (T)this.configuration.getMapper(type, (SqlSession)this);
    }

    public Connection getConnection() {
        try {
            return this.executor.getTransaction().getConnection();
        }
        catch (SQLException e) {
            throw ExceptionFactory.wrapException((String)("Error getting a new connection.  Cause: " + e), (Exception)e);
        }
    }

    public void clearCache() {
        this.executor.clearLocalCache();
    }

    private <T> void registerCursor(Cursor<T> cursor) {
        if (this.cursorList == null) {
            this.cursorList = new ArrayList();
        }
        this.cursorList.add(cursor);
    }

    private boolean isCommitOrRollbackRequired(boolean force) {
        return false;
    }

    private Object wrapCollection(Object object) {
        return ParamNameResolver.wrapToMapIfCollection((Object)object, null);
    }

    @Deprecated
    public static class StrictMap<V>
    extends HashMap<String, V> {
        private static final long serialVersionUID = -5741767162221585340L;

        @Override
        public V get(Object key) {
            if (!super.containsKey(key)) {
                throw new BindingException("Parameter '" + key + "' not found. Available parameters are " + this.keySet());
            }
            return super.get(key);
        }
    }
}

