/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.xa.mybatis;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.ucp.jdbc.PoolXADataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.transaction.TransactionException;
import org.apache.ibatis.transaction.jdbc.JdbcTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroTxTransaction
extends JdbcTransaction {
    private static final Log log = LogFactory.getLog(JdbcTransaction.class);
    protected Connection connection;
    protected DataSource dataSource;
    protected TransactionIsolationLevel level;
    protected boolean autoCommit;
    protected boolean skipSetAutoCommitOnClose;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public MicroTxTransaction(DataSource ds, TransactionIsolationLevel desiredLevel, boolean desiredAutoCommit) {
        this(ds, desiredLevel, desiredAutoCommit, false);
    }

    public MicroTxTransaction(DataSource ds, TransactionIsolationLevel desiredLevel, boolean desiredAutoCommit, boolean skipSetAutoCommitOnClose) {
        super(ds, desiredLevel, desiredAutoCommit, skipSetAutoCommitOnClose);
        this.dataSource = ds;
        this.level = desiredLevel;
        this.autoCommit = desiredAutoCommit;
        this.skipSetAutoCommitOnClose = skipSetAutoCommitOnClose;
    }

    public MicroTxTransaction(Connection connection) {
        super(connection);
        this.connection = connection;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.openConnection();
        }
        return this.connection;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.resetAutoCommit();
            LOGGER.debug("Closing MyBatis Connection [" + this.connection + "]");
            this.connection.close();
        }
    }

    protected void setDesiredAutoCommit(boolean desiredAutoCommit) {
        try {
            if (this.connection.getAutoCommit() != desiredAutoCommit) {
                LOGGER.debug("Setting autocommit to " + desiredAutoCommit + " on JDBC Connection [" + this.connection + "]");
                this.connection.setAutoCommit(desiredAutoCommit);
            }
        }
        catch (SQLException e) {
            throw new TransactionException("Error configuring AutoCommit.  Your driver may not support getAutoCommit() or setAutoCommit(). Requested setting: " + desiredAutoCommit + ".  Cause: " + e, (Throwable)e);
        }
    }

    protected void resetAutoCommit() {
        block4: {
            try {
                if (!this.skipSetAutoCommitOnClose && !this.connection.getAutoCommit()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Resetting autocommit to true on JDBC Connection [" + this.connection + "]");
                    }
                    this.connection.setAutoCommit(false);
                }
            }
            catch (SQLException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Error resetting autocommit to true before closing the connection.  Cause: " + e);
            }
        }
    }

    protected void openConnection() throws SQLException {
        LOGGER.debug("Opening JDBC Connection for MyBatis XA Transaction");
        try {
            if (this.dataSource != null && this.dataSource instanceof XADataSource) {
                String rmid = this.dataSource instanceof PoolXADataSource && ((PoolXADataSource)this.dataSource).getDataSourceName() != null ? TrmXAResourceManager.getDsToRmidMapWithDefault(((PoolXADataSource)this.dataSource).getDataSourceName()) : MicroTxConfig.resourceManagerId;
                XAConnection xaConnection = null;
                if (MicroTxXaTxnStoreService.getTrmXaContextS(rmid) != null) {
                    xaConnection = MicroTxXaTxnStoreService.getTrmXaContextS((String)rmid).xaCon;
                } else {
                    LOGGER.error("XA Context is null for RMID: {}", (Object)rmid);
                }
                if (xaConnection == null) {
                    LOGGER.error("XA Connection is null. Cannot initialize MyBatis XA Transaction");
                    throw new TransactionException("XA Connection is null. Cannot initialize MyBatis XA Transaction");
                }
                this.connection = xaConnection.getConnection();
                LOGGER.debug("Successfully set the XA Connection to MyBatis XA Transaction");
                if (this.level != null) {
                    this.connection.setTransactionIsolation(this.level.getLevel());
                }
            } else {
                throw new TransactionException("Non-XA datasource is not supported");
            }
            this.setDesiredAutoCommit(this.autoCommit);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransactionException("Exception during xa start " + e.getMessage());
        }
    }
}

