/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.xa.mybatis;

import com.oracle.microtx.xa.mybatis.MicroTxTransaction;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionFactory;

public class MicroTxTransactionFactory
implements TransactionFactory {
    private boolean skipSetAutoCommitOnClose;

    public void setProperties(Properties props) {
        if (props == null) {
            return;
        }
        String value = props.getProperty("skipSetAutoCommitOnClose");
        if (value != null) {
            this.skipSetAutoCommitOnClose = Boolean.parseBoolean(value);
        }
    }

    public Transaction newTransaction(Connection conn) {
        return new MicroTxTransaction(conn);
    }

    public Transaction newTransaction(DataSource ds, TransactionIsolationLevel level, boolean autoCommit) {
        return new MicroTxTransaction(ds, level, autoCommit, this.skipSetAutoCommitOnClose);
    }
}

