/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.xa.rm;

import com.oracle.microtx.exception.MicroTxException;
import com.oracle.microtx.springboot.MicroTxClientMain;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.coordinator.CoordinatorEnlistResponse;
import com.oracle.microtx.xa.coordinator.MicroTxCoordinatorClient;
import com.oracle.microtx.xa.rm.ResourceManagerClient;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicConnectionFactory;
import jakarta.jms.XATopicSession;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.transaction.SystemException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import oracle.jakarta.jms.AQjmsFactory;
import oracle.tmm.common.TmsHostCache;
import oracle.tmm.jta.CoordinatorPayloadBuilder;
import oracle.tmm.jta.common.ThreadLocalXAConnection;
import oracle.tmm.jta.common.TrmXAResource;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.tmm.jta.common.TrmXAResourceType;
import oracle.tmm.jta.common.TrmXaContext;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.jta.common.XAConstants;
import oracle.tmm.jta.exceptions.ExceptionUtils;
import oracle.tmm.jta.exceptions.TrmEnlistmentException;
import oracle.tmm.jta.pojo.TcsEnlistedResponsePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class MicroTxResourceManagerClient
implements ResourceManagerClient {
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    MicroTxCoordinatorClient microTxCoordinatorClient;
    @Autowired
    MicroTxClientMain microTxClientMain;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public TrmXid enlist(String rmid, boolean isJms) {
        TrmXid xid = null;
        try {
            XAConnection xaConnection = null;
            EntityManager entityManager = null;
            XATopicConnection xaTopicConnection = null;
            XATopicSession xaTopicSession = null;
            String requestId = this.microTxXaTxnStoreService.getRequestId();
            TrmXAResource trmXAResource = TrmXAResourceManager.getXaTrmResource(rmid);
            XADataSource xaDataSource = null;
            if (trmXAResource.getEntityManagerFactory() != null) {
                EntityManagerFactory emf = trmXAResource.getEntityManagerFactory();
                entityManager = emf.createEntityManager();
                if (entityManager.getEntityManagerFactory().getProperties().get("hibernate.connection.datasource") != null) {
                    xaDataSource = (XADataSource)entityManager.getEntityManagerFactory().getProperties().get("hibernate.connection.datasource");
                    xaConnection = xaDataSource.getXAConnection();
                    ThreadLocalXAConnection.set(rmid, xaConnection);
                    LOGGER.info("Connection Enlistment xaConnection: {}", (Object)xaConnection);
                } else {
                    xaConnection = ThreadLocalXAConnection.get(rmid);
                    if (xaConnection != null) {
                        LOGGER.info("Connection Enlistment xaConnection set by eclipselink connector: {}", (Object)xaConnection);
                    } else if (trmXAResource.getXaDS() != null) {
                        xaDataSource = trmXAResource.getXaDS();
                        xaConnection = xaDataSource.getXAConnection();
                        ThreadLocalXAConnection.set(rmid, xaConnection);
                        LOGGER.info("xaConnection: " + xaConnection);
                    }
                }
            } else {
                xaDataSource = TrmXAResourceManager.getXaDS(rmid);
                xaConnection = xaDataSource.getXAConnection();
            }
            if (isJms) {
                XATopicConnectionFactory tcf = AQjmsFactory.getXATopicConnectionFactory((XADataSource)xaDataSource);
                xaTopicConnection = tcf.createXATopicConnection();
                xaTopicConnection.start();
                xaTopicSession = xaTopicConnection.createXATopicSession();
            }
            String transactionUrl = TmsHostCache.checkTmsHostReachable(this.microTxXaTxnStoreService.getInternalURI()) ? this.microTxXaTxnStoreService.getInternalURI() : this.microTxXaTxnStoreService.getExternalURI();
            CoordinatorEnlistResponse enlistResponse = this.microTxCoordinatorClient.enlist(rmid, requestId, transactionUrl, CoordinatorPayloadBuilder.getRmInstanceName(rmid, xaConnection));
            String gtrid = transactionUrl.substring(transactionUrl.lastIndexOf(47) + 1);
            xid = this.afterEnlist(rmid, gtrid, enlistResponse, xaConnection, requestId, entityManager, xaTopicConnection, xaTopicSession);
            this.microTxXaTxnStoreService.setEnlistedXid(rmid, xid);
            LOGGER.debug("{} : Enlisted", (Object)rmid);
        }
        catch (XAException e) {
            String errMsg = "XaConnection Error with XAException: message " + Optional.ofNullable(e.getMessage()).orElse("") + " " + Optional.ofNullable(e.getCause().getMessage()).orElse("") + " , Error " + XAConstants.XAErrorCode.getErrorMessage(e.errorCode) + ", Error Code " + e.errorCode;
            LOGGER.error(errMsg);
            throw new TrmEnlistmentException(errMsg);
        }
        catch (Exception e) {
            String errMsg = "Connection enlistment failed with Exception: " + ExceptionUtils.getExceptionMetadata(e);
            LOGGER.error(errMsg);
            throw new TrmEnlistmentException(errMsg);
        }
        return xid;
    }

    @Override
    public TrmXid afterEnlist(String rmid, String gtrid, CoordinatorEnlistResponse enlistResponse, XAConnection xaConnection, String requestId, EntityManager entityManager, XATopicConnection xaTopicConnection, XATopicSession xaTopicSession) throws XAException, SystemException, Exception {
        List<TcsEnlistedResponsePayload.Branch> branchList = enlistResponse.getTcsEnlistedResponsePayload().branches;
        if (branchList.size() == 0) {
            throw new MicroTxException("The tcs enlist Response , branches parameter is having no Values");
        }
        String bqual = branchList.get((int)0).bqual;
        TrmXid xid = new TrmXid(gtrid, 0, bqual);
        this.microTxXaTxnStoreService.setEnlistedXid(rmid, xid);
        TrmXaContext ctx = TrmXAResourceManager.addXaContext(rmid, xid, xaConnection, requestId, entityManager, xaTopicConnection, xaTopicSession);
        this.microTxXaTxnStoreService.setTrmXaContext(rmid, ctx);
        int timeout = enlistResponse.getTcsEnlistedResponsePayload().getTimeout();
        LOGGER.info(ctx.xaRes.setTransactionTimeout((int)TimeUnit.MILLISECONDS.toSeconds(timeout)) ? "timeout value {}s set successfully" : "failed to set timeout value {}s", (Object)ctx.xaRes.getTransactionTimeout());
        if (!this.microTxXaTxnStoreService.isLocalTransactionPresent() || !this.microTxXaTxnStoreService.getLocalTransactionRmid().equals(rmid)) {
            if (enlistResponse.getHttpStatusCode() == HttpStatus.CREATED.value()) {
                ctx.xaRes.start(xid, 0);
                LOGGER.trace("rmid {} , XaResource start(TMNOFLAGS) with xid {}", (Object)rmid, (Object)xid);
            } else if (MicroTxClientMain.trmXAResourceType == TrmXAResourceType.PostgreSQL) {
                ctx.xaRes.start(xid, 0x200000);
                LOGGER.trace("rmid {} , XaResource start(TMJOIN) with xid {}", (Object)rmid, (Object)xid);
            } else if (enlistResponse.getHttpStatusCode() == HttpStatus.OK.value()) {
                ctx.xaRes.start(xid, 0x8000000);
                LOGGER.trace("rmid {} , XaResource start(TMRESUME) with xid {}", (Object)rmid, (Object)xid);
            } else {
                ctx.xaRes.start(xid, 0);
                LOGGER.trace("rmid {} , XaResource start(TMNOFLAGS) with xid {}", (Object)rmid, (Object)xid);
            }
        }
        if (ctx.entityManager != null) {
            ctx.entityManager.getTransaction().begin();
            LOGGER.trace("rmid {} , entity manager begin with xid {}", (Object)rmid, (Object)xid);
        }
        LOGGER.info("XID: {}", (Object)xid);
        return xid;
    }
}

