/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.xa.rm;

import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MicroTxUserTransaction
implements UserTransaction {
    public String gtrid = "";
    public String txnUrl = "";
    public String txnInternalUrl = "";
    public String txnExternalUrl = "";
    protected int timeout = 0;
    protected boolean rollbackOnly = false;
    protected boolean suspended = false;
    protected static final String NO_TX_CUR_THREAD = "No transaction associated with current thread";
    protected Map<String, Object> insProperties = new HashMap<String, Object>();
    protected static final Logger LOGGER = LoggerFactory.getLogger(MicroTxUserTransaction.class);

    public abstract void startTCSGlobalTransaction() throws IllegalStateException, SystemException;

    public abstract void suspend() throws IllegalStateException;

    public abstract void resume() throws IllegalStateException;

    public void setRollbackOnly() throws IllegalStateException {
        if (this.gtrid.isEmpty()) {
            LOGGER.warn("Transaction {} has been set to rollbackonly", (Object)this.gtrid);
            throw new IllegalStateException(NO_TX_CUR_THREAD);
        }
        this.rollbackOnly = true;
    }

    public void setTransactionTimeout(int timeout) {
        if (!this.gtrid.isEmpty()) {
            throw new IllegalStateException("TransactionTimeout has to be set before beginning the transaction.");
        }
        this.timeout = timeout;
    }

    public int getTransactionTimeout() {
        return this.timeout;
    }

    public String getTxnInternalUrl() throws IllegalStateException {
        if (this.txnUrl.isEmpty()) {
            throw new IllegalStateException(NO_TX_CUR_THREAD);
        }
        return this.txnInternalUrl;
    }

    public String getTxnExternalUrl() throws IllegalStateException {
        if (this.txnExternalUrl.isEmpty()) {
            throw new IllegalStateException(NO_TX_CUR_THREAD);
        }
        return this.txnExternalUrl;
    }

    public String getTxnUrl() throws IllegalStateException {
        if (this.txnUrl.isEmpty()) {
            throw new IllegalStateException(NO_TX_CUR_THREAD);
        }
        return this.txnUrl;
    }

    public void setProperty(String propertyName, Object propertyValue) {
        this.insProperties.put(propertyName, propertyValue);
    }

    public String getTransactionID() throws IllegalStateException {
        if (this.gtrid.isEmpty()) {
            throw new IllegalStateException(NO_TX_CUR_THREAD);
        }
        return this.gtrid;
    }

    public Map<String, Object> getInsProperties() {
        return this.insProperties;
    }

    public void setInsProperties(Map<String, Object> insProperties) {
        this.insProperties = insProperties;
    }
}

