/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.xa.rm;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.common.SpringBootTransactionUtils;
import com.oracle.microtx.springboot.interceptor.MicroTxInterceptorService;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.coordinator.CoordinatorEnlistResponse;
import com.oracle.microtx.xa.coordinator.MicroTxCoordinatorClient;
import com.oracle.microtx.xa.rm.MicroTxUserTransaction;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import javax.transaction.xa.XAException;
import oracle.tmm.common.TmsHostCache;
import oracle.tmm.jta.common.TrmXaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.annotation.RequestScope;

@Service
@RequestScope
public class MicroTxUserTransactionService
extends MicroTxUserTransaction {
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    MicroTxCoordinatorClient microTxCoordinatorClient;
    @Autowired
    MicroTxInterceptorService microTxInterceptorService;
    @Autowired
    SpringBootTransactionUtils transactionUtils;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public MicroTxUserTransactionService() {
    }

    MicroTxUserTransactionService(Builder builder) {
        this.txnInternalUrl = builder.txnInternalUrl;
        this.txnExternalUrl = builder.txnExternalUrl;
        this.txnUrl = TmsHostCache.checkTmsHostReachable(this.txnInternalUrl) ? this.txnInternalUrl : this.txnExternalUrl;
        this.gtrid = this.txnInternalUrl.substring(this.txnInternalUrl.lastIndexOf(47) + 1);
        LOGGER.info("begin  " + this.txnUrl);
        this.microTxXaTxnStoreService.setUserTransaction(this);
        this.timeout = MicroTxConfig.getXaTransactionTimeout();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(false);
    }

    public void begin(boolean enlist) throws NotSupportedException, SystemException {
        if (this.microTxXaTxnStoreService.getUserTransaction() != null) {
            LOGGER.debug("There is already a transaction {} associated with the thread", (Object)this.microTxXaTxnStoreService.getUserTransaction().getTransactionID());
            throw new IllegalStateException("There is already a transaction associated with the thread");
        }
        this.microTxXaTxnStoreService.setIsPromotable(MicroTxConfig.isXaPromotableActive());
        this.microTxXaTxnStoreService.setIsLocalTransactionAvailable(this.microTxXaTxnStoreService.isPromotable());
        this.microTxXaTxnStoreService.setLocalUserTransaction(this);
        if (enlist) {
            this.microTxXaTxnStoreService.setIsInitiatorAsParticipant();
        }
        if (!this.microTxXaTxnStoreService.isPromotable().booleanValue()) {
            this.startTCSGlobalTransaction();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.microTxXaTxnStoreService.getIsLocalTransactionAvailable().booleanValue()) {
            LOGGER.info("Commit the Local Transaction Rmid " + this.microTxXaTxnStoreService.getLocalTransactionRmid());
            TrmXaContext localtransactionContext = this.microTxXaTxnStoreService.getLocalTransactionContext();
            try {
                if (localtransactionContext.entityManager != null) {
                    localtransactionContext.entityManager.getTransaction().commit();
                } else {
                    if (localtransactionContext.connection.isClosed()) {
                        LOGGER.error("The Local Connection is Closed");
                    }
                    localtransactionContext.connection.commit();
                }
                localtransactionContext.close();
            }
            catch (SQLException e) {
                LOGGER.error("The local connection commit failed " + e.getMessage());
                throw new RollbackException("The local connection commit failed");
            }
            finally {
                try {
                    localtransactionContext.xaCon.close();
                }
                catch (SQLException e) {
                    LOGGER.error("The XA connection connection closed failed " + e.getMessage());
                }
            }
            return;
        }
        Set<String> allRmids = this.microTxXaTxnStoreService.getAllRmids();
        for (String rmid : allRmids) {
            TrmXaContext ctx = this.microTxXaTxnStoreService.getTrmXaContext(rmid);
            if (ctx == null) continue;
            try {
                ctx.xaRes.end(ctx.trmXid, 0x4000000);
                LOGGER.trace("rmid {} , XaResource end(TMSUCCESS) for xid {} ", (Object)rmid, (Object)ctx.trmXid.contextString());
                ctx.close();
                LOGGER.info("XA CTX close for XID " + ctx.trmXid.contextString());
            }
            catch (XAException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        if (this.gtrid.isEmpty()) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        if (this.rollbackOnly) {
            this.rollback();
            throw new RollbackException("Transaction marked as rollback only");
        }
        this.microTxCoordinatorClient.commit(this.gtrid, this.txnUrl);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        LOGGER.info("Xa rollback called gtrid:" + this.gtrid);
        if (this.microTxXaTxnStoreService.getIsLocalTransactionAvailable().booleanValue()) {
            try {
                LOGGER.info("RollBack the Local Transaction , Rmid :" + this.microTxXaTxnStoreService.getLocalTransactionRmid());
                TrmXaContext localtransactionContext = this.microTxXaTxnStoreService.getLocalTransactionContext();
                localtransactionContext.connection.rollback();
                localtransactionContext.close();
                return;
            }
            catch (SQLException e) {
                LOGGER.error("The local connection RollBack failed " + e.getMessage());
                throw new IllegalStateException();
            }
        }
        if (this.gtrid.isEmpty()) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        Set<String> allRmids = this.microTxXaTxnStoreService.getAllRmids();
        for (String rmid : allRmids) {
            TrmXaContext ctx = this.microTxXaTxnStoreService.getTrmXaContext(rmid);
            if (ctx == null) continue;
            try {
                ctx.xaRes.end(ctx.trmXid, 0x4000000);
                LOGGER.trace("rmid {} , XaResource end(TMSUCCESS) for xid {} ", (Object)rmid, (Object)ctx.trmXid.contextString());
                ctx.close();
                LOGGER.info("XA CTX close for XID " + ctx.trmXid.contextString());
            }
            catch (XAException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        this.microTxCoordinatorClient.rollback(this.gtrid, this.txnUrl);
    }

    public int getStatus() throws SystemException {
        if (this.gtrid.isEmpty()) {
            return 6;
        }
        if (this.rollbackOnly) {
            return 1;
        }
        return this.microTxCoordinatorClient.getStatus(this.gtrid, this.txnUrl);
    }

    @Override
    public void startTCSGlobalTransaction() throws IllegalStateException, SystemException {
        if (this.timeout == 0) {
            this.timeout = MicroTxConfig.getXaTransactionTimeout();
        }
        String newGtrid = UUID.randomUUID().toString();
        CoordinatorEnlistResponse response = this.microTxCoordinatorClient.begin(newGtrid, this.timeout, this.insProperties);
        LOGGER.info("XA txn begin response " + response);
        this.txnInternalUrl = response.getTcsEnlistedResponsePayload().internal;
        this.txnExternalUrl = response.getTcsEnlistedResponsePayload().external;
        this.txnUrl = TmsHostCache.checkTmsHostReachable(this.txnInternalUrl) ? this.txnInternalUrl : this.txnExternalUrl;
        String[] temp = this.txnInternalUrl.split("/");
        this.gtrid = temp[temp.length - 1];
        this.microTxXaTxnStoreService.setInternalURI(this.txnInternalUrl);
        this.microTxXaTxnStoreService.setExternalURI(this.txnExternalUrl);
        this.microTxXaTxnStoreService.setGlobalTransactionId(this.gtrid);
        this.transactionUtils.setTxIdToThreadLocal(this.gtrid);
        this.microTxXaTxnStoreService.setUserTransaction(this);
        this.microTxInterceptorService.setTransactionTokenHeader(response.getTransactionTokenHeader());
    }

    @Override
    public void suspend() throws IllegalStateException {
        if (this.gtrid.isEmpty()) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        this.suspended = true;
        this.microTxXaTxnStoreService.removeUserTransaction();
    }

    @Override
    public void resume() throws IllegalStateException {
        if (!this.suspended) {
            throw new IllegalStateException("Transaction not in suspended state");
        }
        this.suspended = false;
        this.microTxXaTxnStoreService.setUserTransaction(this);
    }

    public static class Builder {
        private final String txnInternalUrl;
        private final String txnExternalUrl;

        public Builder(String txnInternalUrl, String txnExternalUrl) {
            this.txnInternalUrl = txnInternalUrl;
            this.txnExternalUrl = txnExternalUrl;
        }

        public MicroTxUserTransactionService build() throws IllegalStateException, SystemException {
            return new MicroTxUserTransactionService(this);
        }
    }
}

