/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.xa.rm;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.oracle.microtx.xa.rm.CallbackResponse;
import com.oracle.microtx.xa.rm.XACallbackStatus;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.transaction.xa.XAException;
import oracle.tmm.jta.XAOperation;
import oracle.tmm.jta.common.InstrUtil;
import oracle.tmm.jta.common.TransactionNotFoundException;
import oracle.tmm.jta.common.TrmXAResource;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.tmm.jta.common.XAConstants;
import oracle.tmm.jta.exceptions.ExceptionUtils;
import oracle.tmm.jta.nonxa.NonXAException;
import oracle.tmm.jta.pojo.TcsCommitResponsePayload;
import oracle.tmm.jta.pojo.TcsForgetResponsePayload;
import oracle.tmm.jta.pojo.TcsPrepareResponsePayload;
import oracle.tmm.jta.pojo.TcsRecoveryResponse;
import oracle.tmm.jta.pojo.TcsRollBackResponsePayload;
import oracle.tmm.util.ObjectMapperUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface XaCallBack {
    public static final Logger LOGGER = LoggerFactory.getLogger(XaCallBack.class);

    public CallbackResponse prepare(String var1, String var2, String var3, String var4);

    public CallbackResponse commit(String var1, String var2, String var3, boolean var4, boolean var5, String var6);

    public CallbackResponse rollback(String var1, String var2, String var3, boolean var4, String var5);

    public CallbackResponse recover(String var1, String var2, String var3, String var4, String var5);

    public CallbackResponse forget(String var1, String var2, String var3);

    default public String processXAPrepare(TrmXAResource trmXAResource, String gtrid, String rmid, String bqual, String requestId, Map<String, String> instrProp) throws Exception {
        if (trmXAResource.isLLRBranch() || trmXAResource.isLRCBranch()) {
            throw new NonXAException("Prepare is not allowed for LLR/LRC branch");
        }
        InstrUtil.execInstrBefore(instrProp, XAOperation.PREPARE);
        String status = trmXAResource.xaop(rmid, gtrid, bqual, XAOperation.PREPARE, requestId, false, null);
        InstrUtil.execInstrAfter(instrProp, XAOperation.PREPARE);
        return status;
    }

    default public String processXArollback(String gtrid, String rmid, String bqual, Map<String, String> instrProp, String requestId) throws Exception {
        InstrUtil.execInstrBefore(instrProp, XAOperation.ROLLBACK);
        String status = TrmXAResourceManager.xaop(rmid, gtrid, bqual, XAOperation.ROLLBACK, requestId, false, null);
        InstrUtil.execInstrAfter(instrProp, XAOperation.ROLLBACK);
        return status;
    }

    default public String processXaCommit(String rmid, String gtrid, String bqual, String requestId, Boolean onePhase, Map<String, String> instrProp) throws Exception {
        InstrUtil.execInstrBefore(instrProp, XAOperation.COMMIT);
        String status = TrmXAResourceManager.xaop(rmid, gtrid, bqual, XAOperation.COMMIT, requestId, onePhase, null);
        InstrUtil.execInstrAfter(instrProp, XAOperation.COMMIT);
        return status;
    }

    default public CallbackResponse afterXaCommit(Boolean allParticipantsSuccessful, TcsCommitResponsePayload tcsCommitResponsePayload, Set<String> branchError) throws JsonProcessingException {
        if (allParticipantsSuccessful.booleanValue()) {
            XACallbackStatus callbackStatus = new XACallbackStatus();
            tcsCommitResponsePayload.status = callbackStatus.getStatus();
            return new CallbackResponse(ObjectMapperUtil.objectToString(tcsCommitResponsePayload, false), 200);
        }
        if (branchError.size() > 1) {
            tcsCommitResponsePayload.status = "XA_HEURMIX";
            return new CallbackResponse(ObjectMapperUtil.objectToString(tcsCommitResponsePayload, false), 207);
        }
        if (branchError.size() == 1) {
            String[] error = branchError.toArray(new String[branchError.size()]);
            tcsCommitResponsePayload.status = error[0];
            return new CallbackResponse(ObjectMapperUtil.objectToString(tcsCommitResponsePayload, false), XAConstants.httpErrorCode(error[0]));
        }
        tcsCommitResponsePayload.status = " Failed in processing error in the branches ";
        return new CallbackResponse(ObjectMapperUtil.objectToString(tcsCommitResponsePayload, false), 401);
    }

    default public void nonXaPrepareCheck(String rmid, Boolean isNonXAParticipant) throws Exception {
        if (isNonXAParticipant.booleanValue()) {
            throw new NonXAException("For Rmid : " + rmid + " , prepare state is a not valid LLR/LRC ");
        }
        throw new NonXAException("The given Rmid : " + rmid + " , is not valid ");
    }

    default public CallbackResponse afterXAPrepare(Boolean allParticipantsSuccessful, TcsPrepareResponsePayload reponsepayload, Set<String> branchError) throws JsonProcessingException {
        XACallbackStatus callbackStatus = new XACallbackStatus();
        if (allParticipantsSuccessful.booleanValue()) {
            reponsepayload.status = callbackStatus.getStatus();
            return new CallbackResponse(ObjectMapperUtil.objectToString(reponsepayload, false), 200);
        }
        if (branchError.size() > 1) {
            reponsepayload.status = "XA_HEURMIX";
            return new CallbackResponse(ObjectMapperUtil.objectToString(reponsepayload, false), 207);
        }
        if (branchError.size() == 1) {
            String[] error = branchError.toArray(new String[branchError.size()]);
            reponsepayload.status = error[0];
            return new CallbackResponse(ObjectMapperUtil.objectToString(reponsepayload, false), XAConstants.httpErrorCode(error[0]));
        }
        reponsepayload.status = "Failed in processing error in the branches";
        return new CallbackResponse(ObjectMapperUtil.objectToString(reponsepayload, false), 401);
    }

    default public CallbackResponse afterXARollback(Boolean allParticipantsSuccessful, TcsRollBackResponsePayload tcsRollBackResponsePayload, Set<String> branchError) throws JsonProcessingException {
        if (allParticipantsSuccessful.booleanValue()) {
            XACallbackStatus callbackStatus = new XACallbackStatus();
            tcsRollBackResponsePayload.status = callbackStatus.getStatus();
            return new CallbackResponse(ObjectMapperUtil.objectToString(tcsRollBackResponsePayload, false), 200);
        }
        if (branchError.size() > 1) {
            tcsRollBackResponsePayload.status = "XA_HEURMIX";
            return new CallbackResponse(ObjectMapperUtil.objectToString(tcsRollBackResponsePayload, false), 207);
        }
        if (branchError.size() == 1) {
            String[] error = branchError.toArray(new String[branchError.size()]);
            tcsRollBackResponsePayload.status = error[0];
            return new CallbackResponse(ObjectMapperUtil.objectToString(tcsRollBackResponsePayload.branchStatus, false), XAConstants.httpErrorCode(error[0]));
        }
        tcsRollBackResponsePayload.status = "Failed in processing error in the branches";
        return new CallbackResponse(ObjectMapperUtil.objectToString(tcsRollBackResponsePayload, false), 401);
    }

    default public CallbackResponse afterXARecover(TcsRecoveryResponse tcsRecoverResponse, Set<String> branchErrors) {
        try {
            String stringResponse = ObjectMapperUtil.objectToString(tcsRecoverResponse, false);
            if (!branchErrors.isEmpty()) {
                if (branchErrors.size() > 1) {
                    return new CallbackResponse(stringResponse, 207);
                }
                if (branchErrors.size() == 1) {
                    String[] error = branchErrors.toArray(new String[branchErrors.size()]);
                    String status = error[0];
                    if (status.equals(XAConstants.XAErrorCode.XAER_NOTA.getMessage())) {
                        return new CallbackResponse(stringResponse, 404);
                    }
                    if (XAConstants.RECOVER_HTTP_412_ERRORS.contains(status)) {
                        return new CallbackResponse(stringResponse, 412);
                    }
                    return new CallbackResponse(stringResponse, 207);
                }
            }
            return new CallbackResponse(stringResponse, 200);
        }
        catch (Exception e) {
            return this.exceptionResponse(e);
        }
    }

    default public CallbackResponse afterXAForget(Boolean allParticipantsSuccessful, TcsForgetResponsePayload tcsForgetResponsePayload, Set<String> branchError) throws JsonProcessingException {
        if (allParticipantsSuccessful.booleanValue()) {
            XACallbackStatus callbackStatus = new XACallbackStatus();
            tcsForgetResponsePayload.status = callbackStatus.getStatus();
            return new CallbackResponse(ObjectMapperUtil.objectToString(tcsForgetResponsePayload, false), 200);
        }
        if (branchError.size() > 1) {
            tcsForgetResponsePayload.status = "XA_HEURMIX";
            return new CallbackResponse(ObjectMapperUtil.objectToString(tcsForgetResponsePayload, false), 207);
        }
        if (branchError.size() == 1) {
            String[] error = branchError.toArray(new String[branchError.size()]);
            tcsForgetResponsePayload.status = error[0];
            return new CallbackResponse(ObjectMapperUtil.objectToString(tcsForgetResponsePayload, false), XAConstants.httpErrorCode(error[0]));
        }
        tcsForgetResponsePayload.status = "Failed in processing error in the branches";
        return new CallbackResponse(ObjectMapperUtil.objectToString(tcsForgetResponsePayload, false), 401);
    }

    default public CallbackResponse exceptionResponse(Exception e) {
        String exceptionClassname = e.getClass().getSimpleName();
        if (exceptionClassname.equals(JsonProcessingException.class.getSimpleName()) || exceptionClassname.equals(JsonMappingException.class.getSimpleName())) {
            return new CallbackResponse("NOT_ACCEPTABLE", 406);
        }
        if (exceptionClassname.equals(XAException.class.getSimpleName())) {
            XAException xaException = (XAException)e;
            String errorCodeString = TrmXAResourceManager.getXAErrCodeString(xaException.errorCode);
            LOGGER.error("XA Exception: " + ExceptionUtils.getExceptionMetadata(e) + " XAErr: " + xaException.errorCode + " XAErrString: " + errorCodeString);
            XACallbackStatus callbackStatus = new XACallbackStatus();
            callbackStatus.setStatus(errorCodeString);
            return new CallbackResponse(callbackStatus.getStatus(), 412);
        }
        if (exceptionClassname.equals(TransactionNotFoundException.class.getSimpleName())) {
            LOGGER.error("TransactionNotFoundException: " + Optional.ofNullable(e.getMessage()).orElse(""));
            return new CallbackResponse("NOT_FOUND", 404);
        }
        if (exceptionClassname.equals(SQLException.class.getSimpleName())) {
            SQLException sqlException = (SQLException)e;
            LOGGER.error("SQLException: " + ExceptionUtils.getExceptionMetadata(e) + " Err: " + sqlException.getErrorCode() + "  SQLState: " + sqlException.getSQLState());
            return new CallbackResponse("INTERNAL_SERVER_ERROR", 500);
        }
        if (exceptionClassname.equals(NonXAException.class.getSimpleName())) {
            NonXAException nonXaException = (NonXAException)e;
            String errorCodeString = TrmXAResourceManager.getXAErrCodeString(nonXaException.errorCode);
            LOGGER.error("NonXA Exception: " + ExceptionUtils.getExceptionMetadata(e) + " NonXAErr: " + nonXaException.errorCode + " NonXAErrString: " + errorCodeString);
            XACallbackStatus callbackStatus = new XACallbackStatus();
            callbackStatus.setStatus(errorCodeString);
            return new CallbackResponse("PRECONDITION_FAILED", 412);
        }
        if (e.getCause() != null && e.getCause() instanceof SQLException) {
            LOGGER.error("Sql Exception: " + ExceptionUtils.getExceptionMetadata(e));
            if (e.getCause().getMessage().contains("ORA-24756")) {
                LOGGER.error("ORA-24756. Throwing not found error: " + ExceptionUtils.getExceptionMetadata(e));
                return new CallbackResponse("NOT_FOUND", 404);
            }
            return new CallbackResponse("INTERNAL_SERVER_ERROR", 500);
        }
        LOGGER.error("Exception: " + ExceptionUtils.getExceptionMetadata(e));
        return new CallbackResponse("INTERNAL_SERVER_ERROR", 500);
    }

    default public String exceptionError(Exception e, String rmid) {
        LOGGER.trace("Exception ", (Throwable)e);
        String exceptionClassname = e.getClass().getSimpleName();
        if (exceptionClassname.equals(JsonProcessingException.class.getSimpleName()) || exceptionClassname.equals(JsonMappingException.class.getSimpleName())) {
            return "PAYLOAD_PROCESSING_FAIL";
        }
        if (exceptionClassname.equals(XAException.class.getSimpleName())) {
            XAException xaException = (XAException)e;
            String errorCodeString = TrmXAResourceManager.getXAErrCodeString(xaException.errorCode);
            LOGGER.error("RMID : " + rmid + " XA Exception: " + e.getMessage() + " XAErr: " + xaException.errorCode + " XAErrString: " + errorCodeString);
            return errorCodeString;
        }
        if (exceptionClassname.equals(TransactionNotFoundException.class.getSimpleName())) {
            LOGGER.error("RMID : " + rmid + " TransactionNotFoundException: " + Optional.ofNullable(e.getMessage()).orElse(""));
            return "TransactionNotFoundException";
        }
        if (exceptionClassname.equals(SQLException.class.getSimpleName())) {
            SQLException sqlException = (SQLException)e;
            LOGGER.error("RMID : " + rmid + " SQLException: " + e.getMessage() + " Err: " + sqlException.getErrorCode() + "  SQLState: " + sqlException.getSQLState());
            return "INTERNAL_SERVER_ERROR";
        }
        if (exceptionClassname.equals(NonXAException.class.getSimpleName())) {
            NonXAException nonXaException = (NonXAException)e;
            String errorCodeString = TrmXAResourceManager.getXAErrCodeString(nonXaException.errorCode);
            LOGGER.error("RMID : " + rmid + " NonXA Exception: " + e.getMessage() + " NonXAErr: " + nonXaException.errorCode + " NonXAErrString: " + errorCodeString);
            return "NonXA_Exception";
        }
        if (e instanceof XAException) {
            int errorCode = ((XAException)e).errorCode;
            String errorMessage = XAConstants.XAErrorCode.getErrorMessage(errorCode);
            LOGGER.error("RMID : " + rmid + " XaException message :" + e.getMessage() + " error " + errorMessage);
            return errorMessage;
        }
        if (e.getCause() != null && e.getCause() instanceof SQLException) {
            LOGGER.error("RMID : " + rmid + " Sql Exception: " + e.getMessage());
            return "INTERNAL_SERVER_ERROR";
        }
        LOGGER.error("RMID : " + rmid + " Exception: " + e.getMessage());
        return "INTERNAL_SERVER_ERROR";
    }

    default public List<TcsRecoveryResponse.RecoveredTransaction.TransactionStatus> recoverListOfTransactions(String inputString) {
        String[] xids;
        ArrayList<TcsRecoveryResponse.RecoveredTransaction.TransactionStatus> result = new ArrayList<TcsRecoveryResponse.RecoveredTransaction.TransactionStatus>();
        if (inputString == null || inputString.length() == 0) {
            return result;
        }
        for (String xid : xids = inputString.split(",")) {
            TcsRecoveryResponse.RecoveredTransaction.TransactionStatus transactionStatusBanch = new TcsRecoveryResponse.RecoveredTransaction.TransactionStatus();
            transactionStatusBanch.xid = xid;
            result.add(transactionStatusBanch);
        }
        return result;
    }
}

