/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.microtx.xa.synchronization;

import com.oracle.microtx.exception.MicroTxException;
import com.oracle.microtx.store.MicroTxXaTxnStoreService;
import com.oracle.microtx.xa.coordinator.CoordinatorClient;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import oracle.tmm.jta.common.TrmXaContext;
import oracle.tmm.jta.common.TrmXid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@Component
@RequestScope
public class TrmRegisterSynchronization {
    static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    MicroTxXaTxnStoreService microTxXaTxnStoreService;
    @Autowired
    CoordinatorClient coordinatorClient;

    public void register(String gtrid, String callbackUri) throws Exception {
        this.coordinatorClient.registerSync(gtrid, callbackUri);
    }

    public void register(TrmXid trmXid, String callbackUri) throws Exception {
        if (Objects.nonNull(trmXid)) {
            this.register(new String(trmXid.getGlobalTransactionId()), callbackUri);
            return;
        }
        throw new MicroTxException("Failed to register transaction events. Current thread is not within transaction context.");
    }

    public void register(String callbackUri) throws Exception {
        TrmXaContext trmXaContext = this.microTxXaTxnStoreService.getTrmXaContext();
        if (Objects.nonNull(trmXaContext)) {
            String gtrid = new String(trmXaContext.trmXid.getGlobalTransactionId());
            LOGGER.info("Registering current transaction gtrid {}", (Object)gtrid);
            this.register(gtrid, callbackUri);
            return;
        }
        throw new MicroTxException("Failed to register transaction events. Current thread is not within transaction context.");
    }
}

