/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.common;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;

public class TmsHostCache {
    private static ConcurrentHashMap<String, Boolean> tmsHostReachable = new ConcurrentHashMap();

    private TmsHostCache() {
    }

    public static boolean checkTmsHostReachable(String url) {
        return TmsHostCache.isDnsLookUpSuccess(url);
    }

    private static boolean isDnsLookUpSuccess(String url) {
        boolean reachable = false;
        String host = TmsHostCache.parseHostname(url);
        if (host == null) {
            return false;
        }
        if (tmsHostReachable.containsKey(host)) {
            return tmsHostReachable.get(host);
        }
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host);
            reachable = addresses.length != 0;
        }
        catch (UnknownHostException ex) {
            reachable = false;
        }
        tmsHostReachable.put(host, reachable);
        return reachable;
    }

    private static String parseHostname(String url) {
        try {
            URL url1 = new URL(url);
            return url1.getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

