/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta;

import com.oracle.microtx.exception.MicroTxException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.XAConnection;
import oracle.tmm.jta.common.TrmXAResource;
import oracle.tmm.jta.common.TrmXAResourceManager;
import oracle.tmm.jta.pojo.TcsEnlistRequestPayload;
import oracle.tmm.util.TmmDBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorPayloadBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoordinatorPayloadBuilder.class);

    private CoordinatorPayloadBuilder() {
    }

    public static TcsEnlistRequestPayload buildEnlistPayload(String callbackUrl, String rmid, String rmInstanceName) {
        TcsEnlistRequestPayload enlistTransactionEntity = new TcsEnlistRequestPayload();
        enlistTransactionEntity.setCallbackUrl(callbackUrl);
        enlistTransactionEntity.resourceManagers = new ArrayList<TcsEnlistRequestPayload.ResourceManager>();
        TcsEnlistRequestPayload.ResourceManager participantsEntity = new TcsEnlistRequestPayload.ResourceManager();
        TrmXAResource trmXAResource = TrmXAResourceManager.availableRmidToTrmXaResourceMap.get(rmid);
        if (trmXAResource == null) {
            throw new MicroTxException("The given Rmid is not available in local storage : Rmid " + rmid);
        }
        if (trmXAResource.isLRCSupport) {
            participantsEntity.setLrcSupport(true);
        } else if (trmXAResource.isLLRSupport) {
            participantsEntity.setLlrSupport(true);
        } else {
            participantsEntity.setXaSupport(true);
        }
        if (trmXAResource.isRAC()) {
            LOGGER.info("Enlist : Identified connection instance name : " + rmInstanceName);
            participantsEntity.setInstanceName(rmInstanceName);
        }
        participantsEntity.setResourceManagerId(rmid);
        enlistTransactionEntity.resourceManagers.add(participantsEntity);
        return enlistTransactionEntity;
    }

    public static String getRmInstanceName(String rmid, XAConnection xaConnection) throws SQLException {
        String instanceName = null;
        TrmXAResource trmXAResource = TrmXAResourceManager.availableRmidToTrmXaResourceMap.get(rmid);
        if (trmXAResource == null) {
            throw new MicroTxException("The given Rmid is not available in local storage : Rmid " + rmid);
        }
        if (trmXAResource.isRAC()) {
            instanceName = TmmDBUtils.getInstanceName(xaConnection.getConnection());
            LOGGER.info("Enlist : Identified connection instance name : " + instanceName);
        }
        return instanceName;
    }
}

