/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.transaction.HeuristicCommitException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.SystemException;
import java.util.Arrays;
import oracle.tmm.jta.TrmTcsBranchStatus;

public class TrmTCSResponse {
    public String txid;
    public String status;
    public TrmTcsBranchStatus[] branches;
    private static ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public String toString() {
        return "txid: " + this.txid + " status: " + this.status + " branches: " + Arrays.toString(this.branches);
    }

    public static Exception getException(String tcsResponseString) {
        TrmTCSResponse tcsResponse;
        String msg = tcsResponseString;
        try {
            tcsResponse = (TrmTCSResponse)objectMapper.readValue(tcsResponseString, TrmTCSResponse.class);
        }
        catch (Exception exception) {
            return new SystemException(msg);
        }
        switch (tcsResponse.status) {
            case "TX_MIXED": {
                return new HeuristicMixedException(msg);
            }
            case "TX_HAZARD": {
                return new HeuristicMixedException(msg);
            }
            case "TX_COMMITTED": {
                return new HeuristicCommitException(msg);
            }
            case "TX_PROTOCOL_ERROR": {
                return new IllegalStateException(msg);
            }
            case "TX_FAIL": {
                return new SystemException(msg);
            }
            case "TX_ROLLBACK": {
                return new HeuristicRollbackException(msg);
            }
        }
        return new SystemException(msg);
    }
}

