/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta.common;

import java.util.HashMap;
import java.util.Map;
import oracle.tmm.jta.XAOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstrUtil.class);

    private InstrUtil() {
    }

    public static Map<String, String> getInstrProp(String microTxInstr) {
        HashMap<String, String> resp = new HashMap<String, String>();
        if (microTxInstr == null || microTxInstr.isEmpty()) {
            return resp;
        }
        String[] pairs = microTxInstr.split("::?");
        for (int i = 0; i < pairs.length; i += 2) {
            resp.put(pairs[i], pairs[i + 1]);
        }
        return resp;
    }

    public static void execInstrBefore(Map<String, String> instrProp, XAOperation opr) {
        if (instrProp == null || instrProp.isEmpty()) {
            return;
        }
        if (XAOperation.PREPARE.equals((Object)opr)) {
            instrProp.forEach((key, value) -> {
                if (key.equals("ResourceBeforePrepareExit") && Boolean.parseBoolean(value)) {
                    LOGGER.info("Executing ResourceBeforePrepareExit");
                    Runtime.getRuntime().halt(-1);
                } else if (key.equals("ResourceBeforePrepareSleepMillis")) {
                    long sleepMills = Long.parseLong(value);
                    LOGGER.info("Executing ResourceBeforePrepareSleepMillis with sleepMills:" + sleepMills);
                    try {
                        Thread.sleep(sleepMills);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.getStackTrace().toString());
                    }
                }
            });
        } else if (XAOperation.COMMIT.equals((Object)opr)) {
            instrProp.forEach((key, value) -> {
                if (key.equals("ResourceBeforeCommitExit") && Boolean.parseBoolean(value)) {
                    LOGGER.info("Executing ResourceBeforeCommitExit");
                    Runtime.getRuntime().halt(-1);
                } else if (key.equals("ResourceBeforeCommitSleepMillis")) {
                    long sleepMills = Long.parseLong(value);
                    LOGGER.info("Executing ResourceBeforeCommitSleepMillis with sleepMills:" + sleepMills);
                    try {
                        Thread.sleep(sleepMills);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        } else if (XAOperation.ROLLBACK.equals((Object)opr)) {
            instrProp.forEach((key, value) -> {
                if (key.equals("ResourceBeforeRollbackExit") && Boolean.parseBoolean(value)) {
                    LOGGER.info("Executing ResourceBeforeRollbackExit");
                    Runtime.getRuntime().halt(-1);
                } else if (key.equals("ResourceBeforeRollbackSleepMillis")) {
                    long sleepMills = Long.parseLong(value);
                    LOGGER.info("Executing ResourceBeforeRollbackSleepMillis with sleepMills:" + sleepMills);
                    try {
                        Thread.sleep(sleepMills);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    public static void execInstrAfter(Map<String, String> instrProp, XAOperation opr) {
        if (instrProp == null || instrProp.isEmpty()) {
            return;
        }
        if (XAOperation.PREPARE.equals((Object)opr)) {
            instrProp.forEach((key, value) -> {
                if (key.equals("ResourceAfterPrepareExit") && Boolean.parseBoolean(value)) {
                    LOGGER.info("Executing ResourceAfterPrepareExit");
                    Runtime.getRuntime().halt(-1);
                } else if (key.equals("ResourceAfterPrepareSleepMillis")) {
                    long sleepMills = Long.parseLong(value);
                    LOGGER.info("Executing ResourceAfterPrepareSleepMillis with sleepMills:" + sleepMills);
                    try {
                        Thread.sleep(sleepMills);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        } else if (XAOperation.COMMIT.equals((Object)opr)) {
            instrProp.forEach((key, value) -> {
                if (key.equals("ResourceAfterCommitExit") && Boolean.parseBoolean(value)) {
                    LOGGER.info("Executing ResourceAfterCommitExit");
                    Runtime.getRuntime().halt(-1);
                } else if (key.equals("ResourceAfterCommitSleepMillis")) {
                    long sleepMills = Long.parseLong(value);
                    LOGGER.info("Executing ResourceAfterCommitSleepMillis with sleepMills:" + sleepMills);
                    try {
                        Thread.sleep(sleepMills);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        } else if (XAOperation.ROLLBACK.equals((Object)opr)) {
            instrProp.forEach((key, value) -> {
                if (key.equals("ResourceAfterRollbackExit") && Boolean.parseBoolean(value)) {
                    LOGGER.info("Executing ResourceAfterRollbackExit");
                    Runtime.getRuntime().halt(-1);
                } else if (key.equals("ResourceAfterRollbackSleepMillis")) {
                    long sleepMills = Long.parseLong(value);
                    LOGGER.info("Executing ResourceAfterRollbackSleepMillis with sleepMills:" + sleepMills);
                    try {
                        Thread.sleep(sleepMills);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    public static void execInstrItmBefore(Map<String, String> instrProp, XAOperation opr) {
        if (instrProp == null || instrProp.isEmpty()) {
            return;
        }
        if (XAOperation.PREPARE.equals((Object)opr)) {
            instrProp.forEach((key, value) -> {
                if (key.equals("ITMXAResourceBeforePrepareExit") && Boolean.parseBoolean(value)) {
                    LOGGER.info("Executing ITMXAResourceBeforePrepareExit");
                    Runtime.getRuntime().halt(-1);
                } else if (key.equals("ITMXAResourceBeforePrepareSleepMillis")) {
                    long sleepMills = Long.parseLong(value);
                    LOGGER.info("Executing ITMXAResourceBeforePrepareSleepMillis with sleepMills:" + sleepMills);
                    try {
                        Thread.sleep(sleepMills);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        } else if (XAOperation.COMMIT.equals((Object)opr)) {
            instrProp.forEach((key, value) -> {
                if (key.equals("ITMXAResourceBeforeCommitExit") && Boolean.parseBoolean(value)) {
                    LOGGER.info("Executing ITMXAResourceBeforeCommitExit");
                    Runtime.getRuntime().halt(-1);
                } else if (key.equals("ITMXAResourceBeforeCommitSleepMillis")) {
                    long sleepMills = Long.parseLong(value);
                    LOGGER.info("Executing ITMXAResourceBeforeCommitSleepMillis with sleepMills:" + sleepMills);
                    try {
                        Thread.sleep(sleepMills);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    public static void execInstrItmAfter(Map<String, String> instrProp, XAOperation opr) {
        if (instrProp == null || instrProp.isEmpty()) {
            return;
        }
        if (XAOperation.PREPARE.equals((Object)opr)) {
            instrProp.forEach((key, value) -> {
                if (key.equals("ITMXAResourceAfterPrepareExit") && Boolean.parseBoolean(value)) {
                    LOGGER.info("Executing ITMXAResourceAfterPrepareExit");
                    Runtime.getRuntime().halt(-1);
                } else if (key.equals("ITMXAResourceAfterPrepareSleepMillis")) {
                    long sleepMills = Long.parseLong(value);
                    LOGGER.info("Executing ITMXAResourceAfterPrepareSleepMillis with sleepMills:" + sleepMills);
                    try {
                        Thread.sleep(sleepMills);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        } else if (XAOperation.COMMIT.equals((Object)opr)) {
            instrProp.forEach((key, value) -> {
                if (key.equals("ITMXAResourceAfterCommitExit") && Boolean.parseBoolean(value)) {
                    Runtime.getRuntime().halt(-1);
                } else if (key.equals("ITMXAResourceAfterCommitSleepMillis")) {
                    long sleepMills = Long.parseLong(value);
                    LOGGER.info("Executing ITMXAResourceAfterCommitSleepMillis with sleepMills:" + sleepMills);
                    try {
                        Thread.sleep(sleepMills);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }
}

