/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta.common;

import com.oracle.microtx.common.MicroTxConfig;
import java.util.HashMap;
import javax.sql.XAConnection;

public class ThreadLocalXAConnection {
    private static ThreadLocal<HashMap<String, XAConnection>> xaConnThreadLocal = ThreadLocal.withInitial(() -> new HashMap());
    private static String defaultkey = MicroTxConfig.resourceManagerId != null ? MicroTxConfig.resourceManagerId : "default";

    private ThreadLocalXAConnection() {
    }

    public static void set(XAConnection xaConnection) {
        xaConnThreadLocal.get().put(defaultkey, xaConnection);
    }

    public static XAConnection get() {
        return xaConnThreadLocal.get().get(defaultkey);
    }

    public static void set(String rmid, XAConnection xaConnection) {
        xaConnThreadLocal.get().put(rmid, xaConnection);
    }

    public static XAConnection get(String rmid) {
        return xaConnThreadLocal.get().get(rmid);
    }

    public static void remove() {
        xaConnThreadLocal.remove();
    }

    public static boolean isEmpty() {
        return xaConnThreadLocal.get().isEmpty();
    }

    public static HashMap<String, XAConnection> getXaConnections() {
        return xaConnThreadLocal.get();
    }
}

