/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta.common;

import jakarta.jms.JMSException;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicConnectionFactory;
import jakarta.jms.XATopicSession;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jakarta.jms.AQjmsFactory;
import oracle.tmm.jta.XAOperation;
import oracle.tmm.jta.common.ThreadLocalXAConnection;
import oracle.tmm.jta.common.TransactionNotFoundException;
import oracle.tmm.jta.common.TrmXAResourceType;
import oracle.tmm.jta.common.TrmXaContext;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.util.TmmDBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrmXAResource {
    public XADataSource xaPds;
    public EntityManagerFactory entityMgrFactory;
    public static Map<Integer, String> xaExceptions = new HashMap<Integer, String>();
    public static ConcurrentHashMap<String, TrmXaContext> xaContexts = new ConcurrentHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(TrmXAResource.class);
    public boolean isXaSupport;
    public boolean isLLRSupport;
    public boolean isLRCSupport;
    private boolean isRAC;
    public boolean isJms;
    public TrmXAResourceType trmXAResourceType = TrmXAResourceType.Oracle;

    public boolean isLLRBranch() {
        return !this.isXaSupport && this.isLLRSupport && !this.isLRCSupport;
    }

    public boolean isLRCBranch() {
        return !this.isXaSupport && !this.isLLRSupport && this.isLRCSupport;
    }

    public boolean isRAC() {
        return this.isRAC;
    }

    public void setIsRAC(boolean isRAC) {
        this.isRAC = isRAC;
    }

    public void init(XADataSource xaDataSource) {
        this.xaPds = xaDataSource;
    }

    public void init(EntityManagerFactory entityManagerFactory) {
        this.entityMgrFactory = entityManagerFactory;
    }

    public XADataSource getXaDS() {
        return this.xaPds;
    }

    public void setXaDS(XADataSource xaDataSource) {
        this.xaPds = xaDataSource;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityMgrFactory;
    }

    public static String getXAErrCodeString(int xaErrCode) {
        return xaExceptions.get(xaErrCode);
    }

    public TrmXaContext addXaContext(TrmXid xid, XAConnection xaCon, String requestId, EntityManager entityManager, XATopicConnection xaTopicConnection, XATopicSession xaTopicSession) throws Exception {
        LOGGER.info("addXaContext: " + xid.contextString());
        TrmXaContext ctx = null;
        try {
            if (this.trmXAResourceType == TrmXAResourceType.PostgreSQL && (ctx = xaContexts.get(xid.contextString())) != null) {
                LOGGER.info("Returning existing XaContext: " + xid.contextString());
                return ctx;
            }
            ctx = new TrmXaContext(xaCon, xid, requestId, entityManager, xaTopicConnection, xaTopicSession);
            if (this.trmXAResourceType == TrmXAResourceType.PostgreSQL) {
                xaContexts.put(xid.contextString(), ctx);
            }
        }
        catch (Exception e) {
            LOGGER.error("DEBUG addXaContext  Exception:  ", (Throwable)e);
            throw e;
        }
        return ctx;
    }

    public String xaop(String rmid, String gtrid, String bqual, XAOperation op, String requestId, boolean onePhase, String tmmId) throws XAException, TransactionNotFoundException, SQLException {
        LOGGER.info("For Database Rmid :" + rmid + " xaOp: " + (Object)((Object)op) + " GTRID: " + gtrid + " bqual: " + bqual + "onePhase: " + onePhase);
        TrmXid xid = new TrmXid(gtrid, 0, bqual);
        TrmXaContext ctx = null;
        if (this.trmXAResourceType == TrmXAResourceType.PostgreSQL && (op.equals((Object)XAOperation.PREPARE) || op.equals((Object)XAOperation.ROLLBACK)) && (ctx = xaContexts.get(xid.contextString())) != null) {
            LOGGER.info("Retrieved existing XaContext: " + xid.contextString());
            xid = ctx.trmXid;
        }
        try {
            Object xaTopicConnection;
            if (ctx == null) {
                EntityManager entityManager = null;
                XAConnection xaConnection = null;
                xaTopicConnection = null;
                XATopicSession xaTopicSession = null;
                if (this.getEntityManagerFactory() != null) {
                    entityManager = this.getEntityManagerFactory().createEntityManager();
                    XADataSource xaDataSource = null;
                    if (entityManager.getEntityManagerFactory().getProperties().get("hibernate.connection.datasource") != null) {
                        xaDataSource = (XADataSource)entityManager.getEntityManagerFactory().getProperties().get("hibernate.connection.datasource");
                        xaConnection = xaDataSource.getXAConnection();
                        ThreadLocalXAConnection.set(rmid, xaConnection);
                        LOGGER.info("xaConnection: " + xaConnection);
                    } else {
                        xaConnection = ThreadLocalXAConnection.get(rmid);
                        if (xaConnection != null) {
                            LOGGER.info("xaConnection set by eclipselink connector" + xaConnection);
                        } else if (this.getXaDS() != null) {
                            xaDataSource = this.getXaDS();
                            xaConnection = xaDataSource.getXAConnection();
                            ThreadLocalXAConnection.set(rmid, xaConnection);
                            LOGGER.info("xaConnection: " + xaConnection);
                        }
                    }
                } else if (this.isJms) {
                    XATopicConnectionFactory tcf = AQjmsFactory.getXATopicConnectionFactory((XADataSource)this.getXaDS());
                    xaTopicConnection = tcf.createXATopicConnection();
                    xaTopicConnection.start();
                    xaTopicSession = xaTopicConnection.createXATopicSession();
                } else {
                    xaConnection = this.getXaDS().getXAConnection();
                }
                if (this.isRAC) {
                    LOGGER.info("Connection instance name identified for " + (Object)((Object)op) + " operation :  " + TmmDBUtils.getInstanceName(xaConnection.getConnection()) + " rmid: " + rmid);
                }
                ctx = new TrmXaContext(xaConnection, xid, requestId, entityManager, (XATopicConnection)xaTopicConnection, xaTopicSession);
            }
            LOGGER.info("new CTX allocate xaOp: {} GTRID: {} bqual: {} rmid: {}", new Object[]{op, gtrid, bqual, rmid});
            XAResource xaRes = ctx.xaRes;
            if (op.equals((Object)XAOperation.PREPARE)) {
                int ret = xaRes.prepare(xid);
                if (ret == 0) {
                    LOGGER.trace("Prepare Operation completed for xid {} with status XA_OK", (Object)xid);
                    xaTopicConnection = "XA_OK";
                    return xaTopicConnection;
                }
                if (ret == 3) {
                    LOGGER.trace("Prepare Operation completed for xid {} with status XA_RDONLY", (Object)xid);
                    xaTopicConnection = "XA_RDONLY";
                    return xaTopicConnection;
                }
            }
            if (op.equals((Object)XAOperation.COMMIT)) {
                xaRes.commit(xid, onePhase);
                LOGGER.trace("Commit Operation completed for xid {} ", (Object)xid);
            }
            if (op.equals((Object)XAOperation.ROLLBACK)) {
                xaRes.rollback(xid);
                LOGGER.trace("Rollback Operation completed for xid {} ", (Object)xid);
            }
            if (op.equals((Object)XAOperation.FORGET)) {
                xaRes.forget(xid);
                LOGGER.trace("Forget Operation completed for xid {} ", (Object)xid);
            }
            if (op.equals((Object)XAOperation.RECOVER)) {
                Xid[] xids = null;
                xids = this.trmXAResourceType == TrmXAResourceType.PostgreSQL ? xaRes.recover(0x1800000) : xaRes.recover(0);
                if (xids != null && xids.length > 0) {
                    StringBuilder xidsBuilder = new StringBuilder();
                    Arrays.stream(xids).forEach(rXid -> {
                        if (new String(rXid.getBranchQualifier()).contains(tmmId)) {
                            xidsBuilder.append(new TrmXid((Xid)rXid).contextString()).append(",");
                        }
                    });
                    LOGGER.trace(" xids requires recovery {}", (Object)xidsBuilder.toString());
                    String string = xidsBuilder.toString();
                    return string;
                }
                String string = "";
                return string;
            }
            String string = "XA_OK";
            return string;
        }
        catch (JMSException e) {
            throw new XAException(e.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ctx != null) {
                ctx.close();
                LOGGER.info("new CTX close xaOp: " + (Object)((Object)op) + " GTRID: " + gtrid + " bqual: " + bqual);
            }
            if (this.trmXAResourceType == TrmXAResourceType.PostgreSQL && (op.equals((Object)XAOperation.PREPARE) || op.equals((Object)XAOperation.ROLLBACK))) {
                xaContexts.remove(xid);
            }
        }
    }

    static {
        xaExceptions.put(7, "XA_HEURCOM");
        xaExceptions.put(8, "XA_HEURHAZ");
        xaExceptions.put(5, "XA_HEURMIX");
        xaExceptions.put(6, "XA_HEURRB");
        xaExceptions.put(9, "XA_NOMIGRATE");
        xaExceptions.put(100, "XA_RBBASE");
        xaExceptions.put(101, "XA_RBCOMMFAIL");
        xaExceptions.put(102, "XA_RBDEADLOCK");
        xaExceptions.put(107, "XA_RBEND");
        xaExceptions.put(103, "XA_RBINTEGRITY");
        xaExceptions.put(104, "XA_RBOTHER");
        xaExceptions.put(105, "XA_RBPROTO");
        xaExceptions.put(100, "XA_RBROLLBACK");
        xaExceptions.put(106, "XA_RBTIMEOUT");
        xaExceptions.put(107, "XA_RBTRANSIENT");
        xaExceptions.put(3, "XA_RDONLY");
        xaExceptions.put(4, "XA_RETRY");
        xaExceptions.put(-2, "XAER_ASYNC");
        xaExceptions.put(-8, "XAER_DUPID");
        xaExceptions.put(-5, "XAER_INVAL");
        xaExceptions.put(-4, "XAER_NOTA");
        xaExceptions.put(-9, "XAER_OUTSIDE");
        xaExceptions.put(-6, "XAER_PROTO");
        xaExceptions.put(-3, "XAER_RMERR");
        xaExceptions.put(-7, "XAER_RMFAIL");
    }
}

