/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta.common;

import com.oracle.microtx.common.MicroTxConfig;
import com.oracle.microtx.exception.MicroTxException;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicSession;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import oracle.tmm.jta.XAOperation;
import oracle.tmm.jta.common.DataSourceInfo;
import oracle.tmm.jta.common.TransactionNotFoundException;
import oracle.tmm.jta.common.TrmXAResource;
import oracle.tmm.jta.common.TrmXaContext;
import oracle.tmm.jta.common.TrmXid;
import oracle.tmm.jta.exceptions.MicroTxInitilizationException;
import oracle.tmm.jta.nonxa.NonXAException;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrmXAResourceManager {
    public static Map<String, TrmXAResource> availableRmidToTrmXaResourceMap = new HashMap<String, TrmXAResource>();
    public static Map<String, SqlSessionFactory> availableRmidToSqlSessionFactoryMap = new HashMap<String, SqlSessionFactory>();
    public static Map<String, String> dataSourceNameToRmidMapping = new HashMap<String, String>();
    private static final Logger LOGGER = LoggerFactory.getLogger(TrmXAResourceManager.class);

    private TrmXAResourceManager() {
    }

    public static void init(XADataSource xaDataSource, DataSourceInfo dataSourceInfo) {
        String resourceManagerId = dataSourceInfo.getResourceManagerId();
        TrmXAResourceManager.setDataSourceNameToRmidMapping(dataSourceInfo.getDataSourceName(), resourceManagerId);
        TrmXAResource trmXAResourceInstance = new TrmXAResource();
        if (dataSourceInfo.isLRCSupport().booleanValue()) {
            trmXAResourceInstance.isLRCSupport = true;
        } else if (dataSourceInfo.isLLRSupport().booleanValue()) {
            trmXAResourceInstance.isLLRSupport = true;
        } else {
            trmXAResourceInstance.isXaSupport = true;
        }
        trmXAResourceInstance.setIsRAC(dataSourceInfo.isRAC());
        trmXAResourceInstance.trmXAResourceType = dataSourceInfo.getDatabaseType();
        trmXAResourceInstance.isJms = dataSourceInfo.isJms();
        trmXAResourceInstance.init(xaDataSource);
        TrmXAResourceManager.validateResourceManagerId(resourceManagerId);
        availableRmidToTrmXaResourceMap.put(resourceManagerId, trmXAResourceInstance);
        availableRmidToSqlSessionFactoryMap.put(resourceManagerId, dataSourceInfo.getMicroTxSqlSessionFactory());
    }

    public static void init(EntityManagerFactory entityManagerFactory, DataSourceInfo dataSourceInfo) {
        String resourceManagerId = dataSourceInfo.getResourceManagerId();
        TrmXAResource trmXAResourceInstance = new TrmXAResource();
        trmXAResourceInstance.init(entityManagerFactory);
        trmXAResourceInstance.trmXAResourceType = dataSourceInfo.getDatabaseType();
        trmXAResourceInstance.setIsRAC(dataSourceInfo.isRAC());
        TrmXAResourceManager.validateResourceManagerId(resourceManagerId);
        availableRmidToTrmXaResourceMap.put(resourceManagerId, trmXAResourceInstance);
        availableRmidToSqlSessionFactoryMap.put(dataSourceInfo.getResourceManagerId(), dataSourceInfo.getMicroTxSqlSessionFactory());
        TrmXAResourceManager.setDataSourceNameToRmidMapping(dataSourceInfo.getDataSourceName(), dataSourceInfo.getResourceManagerId());
    }

    public static void init(String rmid, XADataSource xaDataSource) {
        TrmXAResource trmXAResourceInstance = new TrmXAResource();
        trmXAResourceInstance.init(xaDataSource);
        TrmXAResourceManager.validateResourceManagerId(rmid);
        availableRmidToTrmXaResourceMap.put(rmid, trmXAResourceInstance);
    }

    public static XADataSource getXaDS(String rmid) {
        if (availableRmidToTrmXaResourceMap.containsKey(rmid)) {
            return TrmXAResourceManager.availableRmidToTrmXaResourceMap.get((Object)rmid).xaPds;
        }
        return null;
    }

    public static TrmXAResource getXaTrmResource(String rmid) {
        if (availableRmidToTrmXaResourceMap.containsKey(rmid)) {
            return availableRmidToTrmXaResourceMap.get(rmid);
        }
        return null;
    }

    public static EntityManagerFactory getEntityManagerFactory(String databaseName) {
        if (availableRmidToTrmXaResourceMap.containsKey(databaseName)) {
            return TrmXAResourceManager.availableRmidToTrmXaResourceMap.get((Object)databaseName).entityMgrFactory;
        }
        return null;
    }

    public static String getXAErrCodeString(int xaErrCode) {
        return TrmXAResource.xaExceptions.get(xaErrCode);
    }

    public static TrmXaContext addXaContext(String rmid, TrmXid xid, XAConnection xaCon, String requestId, EntityManager entityManager, XATopicConnection xaTopicConnection, XATopicSession xaTopicSession) throws Exception {
        TrmXaContext ctx = null;
        TrmXAResource trmXAResource = availableRmidToTrmXaResourceMap.get(rmid);
        try {
            if (trmXAResource == null) {
                throw new MicroTxException("The Rmid is not available : " + rmid);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception while adding xa context", (Throwable)e);
            return null;
        }
        ctx = trmXAResource.addXaContext(xid, xaCon, requestId, entityManager, xaTopicConnection, xaTopicSession);
        return ctx;
    }

    public static String xaop(String rmid, String gtrid, String bqual, XAOperation op, String requestId, boolean onePhase, String tmmId) throws NonXAException, XAException, TransactionNotFoundException, SQLException {
        TrmXAResource trmXAResource = availableRmidToTrmXaResourceMap.get(rmid);
        if (trmXAResource == null) {
            LOGGER.warn("rmid {} does not exist", (Object)rmid);
            throw new NonXAException("The Rmid is not valid : " + rmid);
        }
        return trmXAResource.xaop(rmid, gtrid, bqual, op, requestId, onePhase, tmmId);
    }

    public static void setDataSourceNameToRmidMapping(String dataSourceName, String rmid) {
        if (dataSourceName != null && !dataSourceName.trim().isEmpty()) {
            dataSourceNameToRmidMapping.put(dataSourceName, rmid);
        }
    }

    public static String getDataSourceNameToRmidMapping(String dataSourceName) {
        return dataSourceNameToRmidMapping.get(dataSourceName);
    }

    public static String getDsToRmidMapWithDefault(String dataSourceName) {
        if (dataSourceName == null || dataSourceName.trim().isEmpty() || !dataSourceNameToRmidMapping.containsKey(dataSourceName)) {
            return MicroTxConfig.resourceManagerId;
        }
        return dataSourceNameToRmidMapping.get(dataSourceName);
    }

    public static TrmXAResource getTrmXaResource(String rmid) {
        return availableRmidToTrmXaResourceMap.get(rmid);
    }

    public static void updateTrmXaResourceDs(String rmid, XADataSource dataSource) {
        availableRmidToTrmXaResourceMap.get(rmid).setXaDS(dataSource);
    }

    private static void validateResourceManagerId(String resourceManagerId) {
        if (Objects.isNull(resourceManagerId) || resourceManagerId.trim().isEmpty()) {
            LOGGER.error("Invalid resource manager id {}", (Object)resourceManagerId);
            throw new MicroTxInitilizationException(String.format("Invalid resource manager id [%s]", resourceManagerId));
        }
    }
}

