/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta.common;

import com.oracle.microtx.exception.MicroTxException;
import java.util.HashMap;
import java.util.Map;

public enum TrmXAResourceType {
    Oracle("ORACLE"),
    MySQL("MYSQL"),
    PostgreSQL("POSTGRESQL");

    private final String value;
    private static Map<String, TrmXAResourceType> map;

    private TrmXAResourceType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static TrmXAResourceType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new MicroTxException("Invalid TrmXAResourceType: " + key);
    }

    static {
        map = new HashMap<String, TrmXAResourceType>();
        for (TrmXAResourceType v : TrmXAResourceType.values()) {
            map.put(v.getValue(), v);
        }
    }
}

