/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta.common;

import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicSession;
import jakarta.persistence.EntityManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import oracle.tmm.jta.common.TrmXid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrmXaContext {
    public XAConnection xaCon = null;
    public Connection connection = null;
    public XAResource xaRes = null;
    public TrmXid trmXid = null;
    public EntityManager entityManager = null;
    public XATopicConnection xaTopicConnection = null;
    public XATopicSession xaTopicSession = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(TrmXaContext.class);

    public TrmXaContext(XAConnection xaCon, TrmXid trmXid, String requestId, EntityManager entityManager) throws SQLException {
        this.xaCon = xaCon;
        this.xaRes = this.xaCon.getXAResource();
        this.trmXid = trmXid;
        this.entityManager = entityManager;
        this.createConnection(requestId);
    }

    public TrmXaContext(XAConnection xaCon, TrmXid trmXid, String requestId, EntityManager entityManager, XATopicConnection xaTopicConnection, XATopicSession xaTopicSession) throws SQLException {
        this.xaCon = xaCon;
        this.xaRes = xaTopicSession != null ? xaTopicSession.getXAResource() : this.xaCon.getXAResource();
        this.trmXid = trmXid;
        this.entityManager = entityManager;
        this.xaTopicConnection = xaTopicConnection;
        this.xaTopicSession = xaTopicSession;
        if (this.xaCon != null) {
            this.createConnection(requestId);
        }
    }

    private void createConnection(String requestId) throws SQLException {
        this.connection = this.xaCon.getConnection();
        if (requestId != null && !requestId.isEmpty()) {
            int MAX_OCSID_CLIENTID_LENGTH = 64;
            Properties prop = new Properties();
            prop.setProperty("OCSID.CLIENTID", requestId.substring(0, Math.min(requestId.length(), 64)));
            this.connection.setClientInfo(prop);
        }
    }

    public void close() {
        try {
            LOGGER.trace("for xid {} , closing the TrmXaContext", (Object)this.trmXid);
            if (this.entityManager != null && this.entityManager.isOpen()) {
                this.entityManager.close();
            }
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
            if (this.xaCon != null) {
                this.xaCon.close();
            }
            if (this.xaTopicSession != null) {
                this.xaTopicSession.close();
            }
            if (this.xaTopicConnection != null) {
                this.xaTopicConnection.close();
            }
            this.xaRes = null;
        }
        catch (Exception e) {
            LOGGER.error("XA CTX close exception: ", (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

