/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta.common;

import java.util.Arrays;
import java.util.Objects;
import javax.transaction.xa.Xid;

public class TrmXid
implements Xid {
    byte[] gtrid;
    int fortmatid;
    byte[] bqual;

    public TrmXid(String gtrid, int formatid, String bqual) {
        this.gtrid = gtrid.getBytes();
        this.fortmatid = formatid;
        this.bqual = bqual.getBytes();
    }

    public TrmXid(Xid xid) {
        this.gtrid = xid.getGlobalTransactionId();
        this.fortmatid = xid.getFormatId();
        this.bqual = xid.getBranchQualifier();
    }

    public String contextString() {
        return new String(this.gtrid) + Integer.toString(this.fortmatid) + new String(this.bqual);
    }

    @Override
    public int getFormatId() {
        return this.fortmatid;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrmXid trmXid = (TrmXid)o;
        return this.fortmatid == trmXid.fortmatid && Arrays.equals(this.gtrid, trmXid.gtrid) && Arrays.equals(this.bqual, trmXid.bqual);
    }

    public int hashCode() {
        int result = Objects.hash(this.fortmatid);
        result = 31 * result + Arrays.hashCode(this.gtrid);
        result = 31 * result + Arrays.hashCode(this.bqual);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.gtrid != null) {
            sb.append(new String(this.gtrid) + " ");
        }
        sb.append(Integer.toString(this.fortmatid) + " ");
        if (this.bqual != null) {
            sb.append(new String(this.bqual));
        }
        return sb.toString();
    }
}

