/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class XAConstants {
    public static final String TCS_XA_PREFIX = "xa-transaction";
    public static final String HEADER_XA_LINK_REL_VAL_EXTERNAL = "https://otmm.oracle.com/xa-transaction/external";
    public static final String HEADER_XA_LINK_REL_VAL_INTERNAL = "https://otmm.oracle.com/xa-transaction/internal";
    public static final String HEADER_XA_LINK_REL_VAL_REGISTERSYNC = "https://otmm.oracle.com/xa-transaction/registersync";
    public static final String HIBERNATE_CONNECTION_DATASOURCE = "hibernate.connection.datasource";
    public static final String XA_OK = "XA_OK";
    public static final String XA_HEURMIX = "XA_HEURMIX";
    public static final String[] ERROR_CODES = new String[]{"XA_RBROLLBACK", "XA_RBINTEGRITY", "XA_RBOTHER", "XA_RBPROTO", "XA_RBTIMEOUT", "XA_RBTRANSIENT", "XAER_RMERR", "XAER_RMFAIL", "XAER_INVAL", "XAER_PROTO"};
    public static final String NONXA_ERROR_CODE = "NonXA_Exception";
    public static final Set<String> RECOVER_HTTP_412_ERRORS = new HashSet<String>(Arrays.asList("XAER_RMERR", "XAER_RMFAIL", "XAER_INVAL", "XAER_PROTO"));
    public static final Set<String> HTTP_412_ERRORS = new HashSet<String>(Arrays.asList(ERROR_CODES));
    private static final int XA_RBBASE_ERROR_CODE = 100;

    private XAConstants() {
    }

    public static boolean isHttp412Error(String errorcode) {
        return HTTP_412_ERRORS.contains(errorcode);
    }

    public static Integer httpErrorCode(String err) {
        if (err.equals("XAER_NOTA")) {
            return 404;
        }
        if (XAConstants.isHttp412Error(err) || err.equals(NONXA_ERROR_CODE)) {
            return 412;
        }
        return 207;
    }

    public static enum XAErrorCode {
        XA_RBROLLBACK(100, "XA_RBROLLBACK"),
        XA_RBCOMMFAIL(101, "XA_RBCOMMFAIL"),
        XA_RBDEADLOCK(102, "XA_RBDEADLOCK"),
        XA_RBINTEGRITY(103, "XA_RBINTEGRITY"),
        XA_RBOTHER(104, "XA_RBOTHER"),
        XA_RBPROTO(105, "XA_RBPROTO"),
        XA_RBTIMEOUT(106, "XA_RBTIMEOUT"),
        XA_RBTRANSIENT(107, "XA_RBTRANSIENT"),
        XA_RBEND(107, "XA_RBEND"),
        XA_NOMIGRATE(9, "XA_NOMIGRATE"),
        XA_HEURHAZ(8, "XA_HEURHAZ"),
        XA_HEURCOM(7, "XA_HEURCOM"),
        XA_HEURRB(6, "XA_HEURRB"),
        XA_HEURMIX(5, "XA_HEURMIX"),
        XA_RETRY(4, "XA_RETRY"),
        XA_RDONLY(3, "XA_RDONLY"),
        XAER_ASYNC(-2, "XAER_ASYNC"),
        XAER_RMERR(-3, "XAER_RMERR"),
        XAER_NOTA(-4, "XAER_NOTA"),
        XAER_INVAL(-5, "XAER_INVAL"),
        XAER_PROTO(-6, "XAER_PROTO"),
        XAER_RMFAIL(-7, "XAER_RMFAIL"),
        XAER_DUPID(-8, "XAER_DUPID"),
        XAER_OUTSIDE(-9, "XAER_OUTSIDE");

        private final int code;
        private final String message;

        private XAErrorCode(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public static String getErrorMessage(int code) {
            for (XAErrorCode errorCode : XAErrorCode.values()) {
                if (errorCode.getCode() != code) continue;
                return errorCode.getMessage();
            }
            return "Unknown XA error code: " + code;
        }
    }
}

