/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.jta.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionUtils.class);

    private ExceptionUtils() {
    }

    public static String getExceptionMetadata(Exception e) {
        Throwable cause = e.getCause();
        StringBuilder exceptionMetadata = new StringBuilder();
        exceptionMetadata.append(cause != null ? cause.getClass().getName() : "").append(cause != null ? cause : "").append(" ").append(Optional.ofNullable(e.getMessage()).orElse("")).append(" ");
        if (cause == null && (e.getMessage() == null || e.getMessage().isEmpty())) {
            LOGGER.error("Exception stack : " + ExceptionUtils.getStackTrace(e));
        }
        return exceptionMetadata.toString();
    }

    private static String getStackTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

