/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

public class ObjectMapperUtil {
    private ObjectMapperUtil() {
    }

    public static <T> T stringToObject(String stringValue, Class<T> targetClass, boolean failOnUnknownProperties) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        if (!failOnUnknownProperties) {
            ObjectMapperUtil.setFailOnUnknownProperties(objectMapper);
        }
        return (T)objectMapper.readValue(stringValue, targetClass);
    }

    public static <T> String objectToString(T inputObject, boolean failOnUnknownProperties) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        if (!failOnUnknownProperties) {
            ObjectMapperUtil.setFailOnUnknownProperties(objectMapper);
        }
        return objectMapper.writeValueAsString(inputObject);
    }

    private static void setFailOnUnknownProperties(ObjectMapper objectMapper) {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
    }
}

