/*
 * Decompiled with CFR 0.152.
 */
package oracle.tmm.util;

import com.oracle.microtx.exception.MicroTxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.XADataSource;
import oracle.jdbc.internal.OracleConnection;

public class TmmDBUtils {
    private TmmDBUtils() {
    }

    public static String getInstanceName(Connection connection) throws SQLException {
        if (connection == null) {
            return "";
        }
        String instanceName = null;
        try {
            instanceName = ((OracleConnection)connection).getServerSessionInfo().getProperty("INSTANCE_NAME");
        }
        catch (SQLException e) {
            throw new SQLException("Failed to extract instance name from connection. Please check if the datasource is of type Oracle " + e.getMessage(), e);
        }
        return instanceName;
    }

    public static boolean isOracleDatabase(Connection connection) throws SQLException {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData != null && (databaseMetaData.getDatabaseProductName() != null && databaseMetaData.getDatabaseProductName().equalsIgnoreCase("Oracle") || databaseMetaData.getDriverName() != null && databaseMetaData.getDriverName().toLowerCase().contains("oracle"));
        }
        catch (SQLException e) {
            throw new SQLException("Unable to extract database metadata from connection object", e);
        }
    }

    public static boolean isOracleDatabase(XADataSource xaDataSource) {
        try {
            return TmmDBUtils.isOracleDatabase(xaDataSource.getXAConnection().getConnection());
        }
        catch (SQLException e) {
            throw new MicroTxException(e.getMessage(), e);
        }
    }
}

