/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver;

import oracle.nosql.driver.OperationThrottlingException;
import oracle.nosql.driver.ReadThrottlingException;
import oracle.nosql.driver.RetryHandler;
import oracle.nosql.driver.RetryableException;
import oracle.nosql.driver.WriteThrottlingException;
import oracle.nosql.driver.ops.Request;

public class DefaultRetryHandler
implements RetryHandler {
    private final int maxRetries;
    private final int fixedDelayMs;

    DefaultRetryHandler(int retries, int delayMS) {
        if (retries < 0) {
            throw new IllegalArgumentException("Retry handler: number of retries must be a non-negative value");
        }
        if (delayMS < 0) {
            throw new IllegalArgumentException("Retry handler: delay milliseconds must be a non-negative value");
        }
        this.fixedDelayMs = delayMS;
        this.maxRetries = retries;
    }

    @Override
    public int getNumRetries() {
        return this.maxRetries;
    }

    @Override
    public boolean doRetry(Request request, int numRetries, RetryableException re) {
        if (re instanceof OperationThrottlingException) {
            return false;
        }
        if (re instanceof ReadThrottlingException || re instanceof WriteThrottlingException || request.shouldRetry()) {
            return numRetries < this.maxRetries;
        }
        return false;
    }

    @Override
    public void delay(Request request, int numRetries, RetryableException re) {
        int delayMs = DefaultRetryHandler.computeBackoffDelay(request, this.fixedDelayMs);
        if (delayMs <= 0) {
            return;
        }
        try {
            Thread.sleep(delayMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        request.addRetryDelayMs(delayMs);
    }

    public static int computeBackoffDelay(Request request, int fixedDelayMs) {
        int delayMs = fixedDelayMs;
        if (delayMs == 0) {
            int mSecToAdd = 200 + (int)(Math.random() * 50.0);
            delayMs = request.getRetryDelayMs();
            delayMs += mSecToAdd;
        }
        long nanosUsed = System.nanoTime() - request.getStartNanos();
        int msUsed = Math.toIntExact(nanosUsed / 1000000L);
        int timeoutMs = request.getTimeoutInternal();
        int msLeft = timeoutMs - msUsed - 1;
        if (msLeft < delayMs && (delayMs = msLeft) < 1) {
            return 0;
        }
        return delayMs;
    }
}

