/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Stack;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.ByteOutputStream;
import oracle.nosql.driver.util.NettyByteInputStream;
import oracle.nosql.driver.util.NettyByteOutputStream;
import oracle.nosql.driver.util.SerializationUtil;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.FieldValueCreator;
import oracle.nosql.driver.values.FieldValueEventHandler;
import oracle.nosql.driver.values.JsonOptions;
import oracle.nosql.driver.values.JsonPrettySerializer;
import oracle.nosql.driver.values.JsonSerializer;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.TimestampValue;

public class Nson {
    public static final int TYPE_ARRAY = 0;
    public static final int TYPE_BINARY = 1;
    public static final int TYPE_BOOLEAN = 2;
    public static final int TYPE_DOUBLE = 3;
    public static final int TYPE_INTEGER = 4;
    public static final int TYPE_LONG = 5;
    public static final int TYPE_MAP = 6;
    public static final int TYPE_STRING = 7;
    public static final int TYPE_TIMESTAMP = 8;
    public static final int TYPE_NUMBER = 9;
    public static final int TYPE_JSON_NULL = 10;
    public static final int TYPE_NULL = 11;
    public static final int TYPE_EMPTY = 12;
    private static String[] NsonTypes = new String[]{"Array", "Binary", "Boolean", "Double", "Integer", "Long", "Map", "String", "Timestamp", "Number", "JsonNull", "Null", "Empty"};

    public static void writeInt(ByteOutputStream out, int value) throws IOException {
        SerializationUtil.writePackedInt(out, value);
    }

    public static void writeLong(ByteOutputStream out, long value) throws IOException {
        SerializationUtil.writePackedLong(out, value);
    }

    public static void writeDouble(ByteOutputStream out, double value) throws IOException {
        out.writeDouble(value);
    }

    public static void writeTimestamp(ByteOutputStream out, TimestampValue value) throws IOException {
        Nson.writeString(out, value.getString());
    }

    public static void writeString(ByteOutputStream out, String s) throws IOException {
        SerializationUtil.writeString(out, s);
    }

    public static void writeCharArrayAsUTF8(ByteOutputStream out, char[] chars) throws IOException {
        Nson.writeByteArray(out, Nson.getCharArrayAsUTF8(chars));
    }

    public static byte[] getCharArrayAsUTF8(char[] chars) throws IOException {
        ByteBuffer buf = StandardCharsets.UTF_8.encode(CharBuffer.wrap(chars));
        byte[] array = new byte[buf.limit()];
        buf.get(array);
        return array;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getSerializedSize(FieldValue value) {
        try (NettyByteOutputStream out = NettyByteOutputStream.createNettyByteOutputStream();){
            int ret;
            Nson.writeFieldValue(out, value);
            int n = ret = out.getOffset();
            return n;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Can't serialize field value: " + ioe.getMessage());
        }
    }

    public static void writeFieldValue(ByteOutputStream out, FieldValue value) throws IOException {
        NsonSerializer ns = new NsonSerializer(out);
        FieldValueEventHandler.generate(value, ns);
    }

    public static void writeByteArray(ByteOutputStream out, byte[] array) throws IOException {
        SerializationUtil.writeByteArray(out, array);
    }

    public static void writeByteArray(ByteOutputStream out, byte[] array, int offset, int length) throws IOException {
        SerializationUtil.writeByteArray(out, array, offset, length);
    }

    public static void writeByteArrayWithInt(ByteOutputStream out, byte[] array) throws IOException {
        out.writeInt(array.length);
        out.write(array);
    }

    public static int readInt(ByteInputStream in) throws IOException {
        return SerializationUtil.readPackedInt(in);
    }

    public static long readLong(ByteInputStream in) throws IOException {
        return SerializationUtil.readPackedLong(in);
    }

    public static double readDouble(ByteInputStream in) throws IOException {
        return in.readDouble();
    }

    public static String readString(ByteInputStream in) throws IOException {
        return SerializationUtil.readString(in);
    }

    public static byte[] readByteArray(ByteInputStream in) throws IOException {
        return SerializationUtil.readByteArray(in);
    }

    public static byte[] readByteArray(ByteInputStream in, boolean skip) throws IOException {
        return SerializationUtil.readByteArray(in, skip);
    }

    public static int[] readIntArray(ByteInputStream in) throws IOException {
        return SerializationUtil.readPackedIntArray(in);
    }

    public static byte[] readByteArrayWithInt(ByteInputStream in) throws IOException {
        int length = in.readInt();
        if (length <= 0) {
            throw new IOException("Invalid length for byte array: " + length);
        }
        byte[] query = new byte[length];
        in.readFully(query);
        return query;
    }

    public static String toJsonString(byte[] nson) {
        return Nson.toJsonString(nson, null);
    }

    public static String toJsonString(byte[] nson, JsonOptions options) {
        if (nson == null) {
            return null;
        }
        JsonSerializer jsonSerializer = new JsonSerializer(options);
        try (NettyByteInputStream bis = NettyByteInputStream.createFromBytes(nson);){
            Nson.generateEventsFromNson(jsonSerializer, bis, false);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error serializing NSON to JSON: " + ioe.getMessage());
        }
        return jsonSerializer.toString();
    }

    public static String toJsonString(ByteInputStream in) {
        return Nson.toJsonString(in, null);
    }

    public static String toJsonString(ByteInputStream in, JsonOptions options) {
        if (in == null) {
            return null;
        }
        JsonSerializer jsonSerializer = options != null && options.getPrettyPrint() ? new JsonPrettySerializer(options) : new JsonSerializer(options);
        try {
            Nson.generateEventsFromNson(jsonSerializer, in, false);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error serializing NSON to JSON: " + ioe.getMessage());
        }
        finally {
            in.close();
        }
        return jsonSerializer.toString();
    }

    public static FieldValue readFieldValue(ByteInputStream in) throws IOException {
        FieldValueCreator handler = new FieldValueCreator();
        Nson.generateEventsFromNson(handler, in, false);
        return handler.getCurrentValue();
    }

    public static void generateEventsFromNson(FieldValueEventHandler handler, ByteInputStream in, boolean skip) throws IOException {
        if (handler == null && !skip) {
            throw new IllegalArgumentException("Handler must be non-null if not skipping");
        }
        if (handler != null && handler.stop()) {
            return;
        }
        byte t = in.readByte();
        switch (t) {
            case 0: {
                int length = in.readInt();
                if (skip) {
                    in.skip(length);
                    break;
                }
                int numElements = in.readInt();
                handler.startArray(numElements);
                if (handler.stop()) {
                    return;
                }
                for (int i = 0; i < numElements; ++i) {
                    skip = handler.startArrayField(i);
                    if (handler.stop()) {
                        return;
                    }
                    Nson.generateEventsFromNson(handler, in, skip);
                    if (handler.stop()) {
                        return;
                    }
                    handler.endArrayField(i);
                    if (!handler.stop()) continue;
                    return;
                }
                handler.endArray(numElements);
                break;
            }
            case 1: {
                byte[] byteVal = Nson.readByteArray(in, skip);
                if (skip) break;
                handler.binaryValue(byteVal);
                break;
            }
            case 2: {
                boolean bval = in.readBoolean();
                if (skip) break;
                handler.booleanValue(bval);
                break;
            }
            case 3: {
                double dval = Nson.readDouble(in);
                if (skip) break;
                handler.doubleValue(dval);
                break;
            }
            case 4: {
                int ival = Nson.readInt(in);
                if (skip) break;
                handler.integerValue(ival);
                break;
            }
            case 5: {
                long lval = Nson.readLong(in);
                if (skip) break;
                handler.longValue(lval);
                break;
            }
            case 6: {
                int length = in.readInt();
                if (skip) {
                    in.skip(length);
                    break;
                }
                int numElements = in.readInt();
                handler.startMap(numElements);
                if (handler.stop()) {
                    return;
                }
                for (int i = 0; i < numElements; ++i) {
                    String key = Nson.readString(in);
                    boolean skipField = handler.startMapField(key);
                    if (handler.stop()) {
                        return;
                    }
                    Nson.generateEventsFromNson(handler, in, skipField);
                    if (handler.stop()) {
                        return;
                    }
                    handler.endMapField(key);
                    if (!handler.stop()) continue;
                    return;
                }
                handler.endMap(numElements);
                break;
            }
            case 7: {
                String sval = Nson.readString(in);
                if (skip) break;
                handler.stringValue(sval);
                break;
            }
            case 8: {
                String tval = Nson.readString(in);
                if (skip) break;
                handler.timestampValue(new TimestampValue(tval, 1));
                break;
            }
            case 9: {
                String nval = Nson.readString(in);
                if (skip) break;
                handler.numberValue(new BigDecimal(nval));
                break;
            }
            case 10: {
                if (skip) break;
                handler.jsonNullValue();
                break;
            }
            case 11: {
                if (skip) break;
                handler.nullValue();
                break;
            }
            case 12: {
                if (skip) break;
                handler.emptyValue();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown value type code: " + t);
            }
        }
    }

    public static int readNsonInt(ByteInputStream in) throws IOException {
        Nson.readType(in, 4);
        return Nson.readInt(in);
    }

    public static long readNsonLong(ByteInputStream in) throws IOException {
        Nson.readType(in, 5);
        return Nson.readLong(in);
    }

    public static double readNsonDouble(ByteInputStream in) throws IOException {
        Nson.readType(in, 3);
        return Nson.readDouble(in);
    }

    public static BigDecimal readNsonNumber(ByteInputStream in) throws IOException {
        Nson.readType(in, 9);
        return new BigDecimal(Nson.readString(in));
    }

    public static boolean readNsonBoolean(ByteInputStream in) throws IOException {
        Nson.readType(in, 2);
        return in.readBoolean();
    }

    public static String readNsonString(ByteInputStream in) throws IOException {
        Nson.readType(in, 7);
        return Nson.readString(in);
    }

    public static byte[] readNsonBinary(ByteInputStream in) throws IOException {
        Nson.readType(in, 1);
        return Nson.readByteArray(in);
    }

    public static MapValue readNsonMap(ByteInputStream in) throws IOException {
        return (MapValue)Nson.readFieldValue(in);
    }

    private static void readType(ByteInputStream in, int expected) throws IOException {
        byte type = in.readByte();
        if (type != expected) {
            Nson.throwTypeMismatch(expected, type);
        }
    }

    private static void throwTypeMismatch(int expected, int found) {
        throw new IllegalArgumentException("Expected type not found, expected type: " + Nson.typeString(expected) + ", found type: " + Nson.typeString(found));
    }

    public static String typeString(int type) {
        if (type < 0 || type >= NsonTypes.length - 1) {
            return "Unknown type: " + type;
        }
        return NsonTypes[type];
    }

    public static class NsonSerializer
    implements FieldValueEventHandler {
        private final ByteOutputStream out;
        private final Stack<Integer> offsetStack;
        private final Stack<Integer> sizeStack;

        public NsonSerializer(ByteOutputStream out) {
            this.out = out;
            this.offsetStack = new Stack();
            this.sizeStack = new Stack();
        }

        public ByteOutputStream getStream() {
            return this.out;
        }

        @Override
        public void startMap(int size) throws IOException {
            this.out.writeByte(6);
            int lengthOffset = this.out.getOffset();
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.offsetStack.push(lengthOffset);
            this.sizeStack.push(0);
        }

        @Override
        public void startArray(int size) throws IOException {
            this.out.writeByte(0);
            int lengthOffset = this.out.getOffset();
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.offsetStack.push(lengthOffset);
            this.sizeStack.push(0);
        }

        @Override
        public void endMap(int size) throws IOException {
            int lengthOffset = this.offsetStack.pop();
            int numElems = this.sizeStack.pop();
            int start = lengthOffset + 4;
            this.out.writeIntAtOffset(lengthOffset, this.out.getOffset() - start);
            this.out.writeIntAtOffset(lengthOffset + 4, numElems);
        }

        @Override
        public void endArray(int size) throws IOException {
            int lengthOffset = this.offsetStack.pop();
            int numElems = this.sizeStack.pop();
            int start = lengthOffset + 4;
            this.out.writeIntAtOffset(lengthOffset, this.out.getOffset() - start);
            this.out.writeIntAtOffset(lengthOffset + 4, numElems);
        }

        @Override
        public boolean startMapField(String key) throws IOException {
            Nson.writeString(this.out, key);
            return false;
        }

        @Override
        public void endMapField(String key) throws IOException {
            this.incrSize();
        }

        @Override
        public void endArrayField(int index) throws IOException {
            this.incrSize();
        }

        @Override
        public void booleanValue(boolean value) throws IOException {
            this.out.writeByte(2);
            this.out.writeBoolean(value);
        }

        @Override
        public void binaryValue(byte[] byteArray) throws IOException {
            this.out.writeByte(1);
            Nson.writeByteArray(this.out, byteArray);
        }

        @Override
        public void binaryValue(byte[] byteArray, int offset, int length) throws IOException {
            this.out.writeByte(1);
            Nson.writeByteArray(this.out, byteArray, offset, length);
        }

        @Override
        public void stringValue(String value) throws IOException {
            this.out.writeByte(7);
            Nson.writeString(this.out, value);
        }

        @Override
        public void integerValue(int value) throws IOException {
            this.out.writeByte(4);
            Nson.writeInt(this.out, value);
        }

        @Override
        public void longValue(long value) throws IOException {
            this.out.writeByte(5);
            Nson.writeLong(this.out, value);
        }

        @Override
        public void doubleValue(double value) throws IOException {
            this.out.writeByte(3);
            Nson.writeDouble(this.out, value);
        }

        @Override
        public void numberValue(BigDecimal value) throws IOException {
            this.out.writeByte(9);
            Nson.writeString(this.out, value.toString());
        }

        @Override
        public void timestampValue(TimestampValue timestamp) throws IOException {
            this.out.writeByte(8);
            Nson.writeTimestamp(this.out, timestamp);
        }

        @Override
        public void jsonNullValue() throws IOException {
            this.out.writeByte(10);
        }

        @Override
        public void nullValue() throws IOException {
            this.out.writeByte(11);
        }

        @Override
        public void emptyValue() throws IOException {
            this.out.writeByte(12);
        }

        private void incrSize() {
            int value = this.sizeStack.pop();
            this.sizeStack.push(value + 1);
        }

        public void incrSize(int delta) {
            int value = this.sizeStack.pop();
            this.sizeStack.push(value + delta);
        }
    }
}

