/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver;

import oracle.nosql.driver.NoSQLException;

public class RequestTimeoutException
extends NoSQLException {
    private static final long serialVersionUID = 1L;
    private volatile int timeoutMs;

    public RequestTimeoutException(String msg) {
        this(0, msg, null);
    }

    public RequestTimeoutException(int timeoutMs, String msg) {
        this(timeoutMs, msg, null);
    }

    public RequestTimeoutException(int timeoutMs, String msg, Throwable cause) {
        super(msg, cause);
        this.timeoutMs = timeoutMs;
    }

    @Override
    public String getMessage() {
        Throwable cause;
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        if (this.timeoutMs != 0) {
            sb.append(" Timeout: ");
            sb.append(this.timeoutMs);
            sb.append("ms");
        }
        if ((cause = this.getCause()) != null) {
            sb.append("\nCaused by: ");
            sb.append(cause.getClass().getName());
            sb.append(": ");
            sb.append(cause.getMessage());
        }
        return sb.toString();
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }
}

