/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.util.logging.Logger;
import oracle.nosql.driver.httpclient.HttpClient;
import oracle.nosql.driver.iam.Utils;
import oracle.nosql.driver.util.HttpRequestUtil;

class InstanceMetadataHelper {
    private static final JsonFactory factory = new JsonFactory();
    private static final String METADATA_SERVICE_BASE_URL = "http://169.254.169.254/opc/v2/";
    private static final String FALLBACK_METADATA_SERVICE_URL = "http://169.254.169.254/opc/v1/";
    static final String AUTHORIZATION_HEADER_VALUE = "Bearer Oracle";
    private static final String METADATA_SERVICE_HOST = "169.254.169.254";

    InstanceMetadataHelper() {
    }

    static String getInstanceMetadaURL(String baseMetadataURL) {
        return baseMetadataURL + "instance/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InstanceMetadata fetchMetadata(int timeout, Logger logger) {
        String baseMetadataURL = METADATA_SERVICE_BASE_URL;
        String instanceMDURL = InstanceMetadataHelper.getInstanceMetadaURL(baseMetadataURL);
        Utils.logTrace(logger, "Fetch instance metadata using " + instanceMDURL);
        HttpClient client = null;
        try {
            client = HttpClient.createMinimalClient(METADATA_SERVICE_HOST, 80, null, 0, "InstanceMDClient", logger);
            HttpRequestUtil.HttpResponse response = HttpRequestUtil.doGetRequest(client, instanceMDURL, InstanceMetadataHelper.headers(), timeout, logger);
            int status = response.getStatusCode();
            if (status == 404) {
                Utils.logTrace(logger, "Falling back to v1 metadata URL, resource not found from v2");
                baseMetadataURL = FALLBACK_METADATA_SERVICE_URL;
                instanceMDURL = InstanceMetadataHelper.getInstanceMetadaURL(baseMetadataURL);
                response = HttpRequestUtil.doGetRequest(client, instanceMDURL, InstanceMetadataHelper.headers(), timeout, logger);
                if (response.getStatusCode() != 200) {
                    throw new IllegalStateException(String.format("Unable to get federation URL frominstance metadata http://169.254.169.254/opc/v2/ or fallback to http://169.254.169.254/opc/v1/, status code: %d, output: %s", response.getOutput()));
                }
            } else if (status != 200) {
                throw new IllegalStateException(String.format("Unable to get federation URL frominstance metadata http://169.254.169.254/opc/v2/, status code: %d, output: %s", response.getStatusCode(), response.getOutput()));
            }
            Utils.logTrace(logger, "Instance metadata " + response.getOutput());
            String insRegion = InstanceMetadataHelper.findRegion(response.getOutput());
            Utils.logTrace(logger, "Instance region " + insRegion);
            InstanceMetadata instanceMetadata = new InstanceMetadata(insRegion, baseMetadataURL);
            return instanceMetadata;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    private static HttpHeaders headers() {
        return new DefaultHttpHeaders().set("Content-Type", (Object)"application/json; charset=UTF-8").set("Authorization", (Object)AUTHORIZATION_HEADER_VALUE);
    }

    private static String findRegion(String response) {
        try {
            JsonParser parser = factory.createParser(response);
            if (parser.getCurrentToken() == null) {
                parser.nextToken();
            }
            while (parser.getCurrentToken() != null) {
                String field = Utils.findField(response, parser, "canonicalRegionName");
                if (field == null) continue;
                parser.nextToken();
                return parser.getText();
            }
            throw new IllegalStateException("Unable to find region in instance metadata " + response);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error parsing instance metadata in response " + response + " " + ioe.getMessage());
        }
    }

    static class InstanceMetadata {
        private String region;
        private String baseMetadataURL;

        InstanceMetadata(String region, String baseMetadataURL) {
            this.region = region;
            this.baseMetadataURL = baseMetadataURL;
        }

        String getRegion() {
            return this.region;
        }

        String getBaseURL() {
            return this.baseMetadataURL;
        }
    }
}

