/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.iam.AuthenticationProfileProvider;
import oracle.nosql.driver.iam.CertificateSupplier;
import oracle.nosql.driver.iam.InstanceMetadataHelper;
import oracle.nosql.driver.iam.SecurityTokenSupplier;
import oracle.nosql.driver.iam.SessionKeyPairSupplier;
import oracle.nosql.driver.iam.Utils;

public class InstancePrincipalsProvider
implements AuthenticationProfileProvider,
Region.RegionProvider,
SecurityTokenSupplier.SecurityTokenBasedProvider {
    protected final SecurityTokenSupplier tokenSupplier;
    protected final SessionKeyPairSupplier.DefaultSessionKeySupplier sessionKeySupplier;
    private final Region region;

    public InstancePrincipalsProvider(SecurityTokenSupplier tokenSupplier, SessionKeyPairSupplier keyPairSupplier, Region region) {
        this.tokenSupplier = tokenSupplier;
        this.sessionKeySupplier = new SessionKeyPairSupplier.DefaultSessionKeySupplier(keyPairSupplier);
        this.region = region;
    }

    @Override
    public void prepare(NoSQLHandleConfig config) {
        this.tokenSupplier.prepare(config);
    }

    @Override
    public void close() {
        this.tokenSupplier.close();
    }

    @Override
    public String getKeyId() {
        return "ST$" + this.tokenSupplier.getSecurityToken();
    }

    @Override
    public InputStream getPrivateKey() {
        return new ByteArrayInputStream(this.sessionKeySupplier.getPrivateKeyBytes());
    }

    @Override
    public char[] getPassphraseCharacters() {
        return null;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public void setMinTokenLifetime(long lifetimeMS) {
        this.tokenSupplier.setMinTokenLifetime(lifetimeMS);
    }

    public static InstancePrincipalsProviderBuilder builder() {
        return new InstancePrincipalsProviderBuilder();
    }

    public static class InstancePrincipalsProviderBuilder {
        private static final int DEFAULT_TIMEOUT_MS = 5000;
        private static final String DEFAULT_PURPOSE = "DEFAULT";
        private String federationEndpoint;
        private InstanceMetadataHelper.InstanceMetadata instanceMetadata;
        private CertificateSupplier leafCertificateSupplier;
        private Set<CertificateSupplier> intermediateCertificateSuppliers;
        private SessionKeyPairSupplier sessSupplier = new SessionKeyPairSupplier.JDKKeyPairSupplier();
        private String tenantId;
        private String purpose = "DEFAULT";
        private int timeout = 5000;
        private Region region;
        private Logger logger;

        public String getFederationEndpoint() {
            return this.federationEndpoint;
        }

        public InstancePrincipalsProviderBuilder setFederationEndpoint(String federationEndpoint) {
            this.federationEndpoint = federationEndpoint;
            return this;
        }

        public CertificateSupplier getLeafCertificateSupplier() {
            return this.leafCertificateSupplier;
        }

        public InstancePrincipalsProviderBuilder setLeafCertificateSupplier(CertificateSupplier supplier) {
            this.leafCertificateSupplier = supplier;
            return this;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public InstancePrincipalsProviderBuilder setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public InstancePrincipalsProviderBuilder setPurpose(String purpose) {
            this.purpose = purpose;
            return this;
        }

        public SessionKeyPairSupplier getSesssionKeyPairSupplier() {
            return this.sessSupplier;
        }

        public InstancePrincipalsProviderBuilder setSessionKeyPairSupplier(SessionKeyPairSupplier sessSupplier) {
            this.sessSupplier = sessSupplier;
            return this;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public InstancePrincipalsProviderBuilder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public InstancePrincipalsProviderBuilder setLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Set<CertificateSupplier> getIntermediateCertificateSuppliers() {
            return this.intermediateCertificateSuppliers;
        }

        public InstancePrincipalsProviderBuilder setIntermediateCertificateSuppliers(Set<CertificateSupplier> suppliers) {
            this.intermediateCertificateSuppliers = suppliers;
            return this;
        }

        public Region getRegion() {
            return this.region;
        }

        public InstancePrincipalsProviderBuilder setRegion(Region r) {
            this.region = r;
            return this;
        }

        public InstancePrincipalsProvider build() {
            if (this.logger == null) {
                this.logger = Logger.getLogger(this.getClass().getName());
            }
            this.autoDetectEndpointUsingMetadataUrl();
            this.autoDetectCertificatesUsingMetadataUrl();
            SecurityTokenSupplier tokenSupplier = new SecurityTokenSupplier(this.federationEndpoint, this.tenantId, this.leafCertificateSupplier, this.intermediateCertificateSuppliers, this.sessSupplier, this.purpose, this.timeout, this.logger);
            return new InstancePrincipalsProvider(tokenSupplier, this.sessSupplier, this.region);
        }

        private void autoDetectEndpointUsingMetadataUrl() {
            if (this.federationEndpoint != null) {
                return;
            }
            String insRegion = this.getInstanceMetadata().getRegion();
            this.federationEndpoint = Utils.getIAMURL(insRegion);
            if (this.region == null) {
                this.region = Region.fromRegionId(insRegion);
            }
            if (this.federationEndpoint == null) {
                throw new IllegalArgumentException("Unable to find IAM URL for unregistered region " + this.region + ", specify the IAM URL instead");
            }
        }

        private void autoDetectCertificatesUsingMetadataUrl() {
            try {
                if (this.leafCertificateSupplier == null) {
                    this.leafCertificateSupplier = new CertificateSupplier.DefaultCertificateSupplier(this.getURLDetails(this.getInstanceMetadata().getBaseURL() + "identity/cert.pem"), this.getURLDetails(this.getInstanceMetadata().getBaseURL() + "identity/key.pem"), null);
                }
                if (this.tenantId == null) {
                    this.tenantId = Utils.getTenantId(this.leafCertificateSupplier.getCertificateAndKeyPair().getCertificate());
                }
                if (this.intermediateCertificateSuppliers == null) {
                    this.intermediateCertificateSuppliers = new HashSet<CertificateSupplier>();
                    this.intermediateCertificateSuppliers.add(new CertificateSupplier.DefaultCertificateSupplier(this.getURLDetails(this.getInstanceMetadata().getBaseURL() + "identity/intermediate.pem"), null, null));
                }
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("The instance metadata service url is invalid.", ex);
            }
        }

        private CertificateSupplier.URLResourceDetails getURLDetails(String url) throws MalformedURLException {
            return new CertificateSupplier.URLResourceDetails(new URL(url)).addHeader("Authorization", "Bearer Oracle");
        }

        private InstanceMetadataHelper.InstanceMetadata getInstanceMetadata() {
            if (this.instanceMetadata == null) {
                this.instanceMetadata = InstanceMetadataHelper.fetchMetadata(this.timeout, this.logger);
            }
            return this.instanceMetadata;
        }
    }
}

