/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.iam.OCIConfigFileReader;
import oracle.nosql.driver.iam.PrivateKeyFileSupplier;
import oracle.nosql.driver.iam.SimpleProfileProvider;
import oracle.nosql.driver.iam.UserAuthenticationProfileProvider;
import oracle.nosql.driver.iam.Utils;
import oracle.nosql.driver.util.CheckNull;

class OCIConfigFileProvider
implements UserAuthenticationProfileProvider,
Region.RegionProvider {
    private final SimpleProfileProvider delegate;

    public OCIConfigFileProvider() throws IOException {
        this(OCIConfigFileReader.parse(OCIConfigFileReader.DEFAULT_FILE_PATH, "DEFAULT"));
    }

    public OCIConfigFileProvider(String profile) throws IOException {
        this(OCIConfigFileReader.parse(OCIConfigFileReader.DEFAULT_FILE_PATH, profile));
    }

    public OCIConfigFileProvider(String configurationFilePath, String profile) throws IOException {
        this(OCIConfigFileReader.parse(configurationFilePath, profile));
    }

    private OCIConfigFileProvider(OCIConfigFileReader.OCIConfigFile configFile) {
        String fingerprint = configFile.get("fingerprint");
        CheckNull.requireNonNullIAE(fingerprint, OCIConfigFileReader.missing("fingerprint"));
        String tenantId = configFile.get("tenancy");
        CheckNull.requireNonNullIAE(tenantId, OCIConfigFileReader.missing("tenancy"));
        String userId = configFile.get("user");
        CheckNull.requireNonNullIAE(userId, OCIConfigFileReader.missing("user"));
        String pemFilePath = configFile.get("key_file");
        CheckNull.requireNonNullIAE(pemFilePath, OCIConfigFileReader.missing("key_file"));
        String passPhrase = configFile.get("pass_phrase");
        PrivateKeyFileSupplier privateKeySupplier = new PrivateKeyFileSupplier(new File(Utils.expandUserHome(pemFilePath)));
        SimpleProfileProvider.SimpleProfileProviderBuilder builder = SimpleProfileProvider.builder().fingerprint(fingerprint).privateKeySupplier(privateKeySupplier).tenantId(tenantId).userId(userId);
        if (passPhrase != null) {
            builder = builder.passphrase(passPhrase.toCharArray());
        }
        builder.region(OCIConfigFileReader.getRegionFromConfigFile(configFile));
        this.delegate = builder.build();
    }

    @Override
    public String getFingerprint() {
        return this.delegate.getFingerprint();
    }

    @Override
    public String getTenantId() {
        return this.delegate.getTenantId();
    }

    @Override
    public String getUserId() {
        return this.delegate.getUserId();
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.delegate.getPassphraseCharacters();
    }

    @Override
    public InputStream getPrivateKey() {
        return this.delegate.getPrivateKey();
    }

    @Override
    public String getKeyId() {
        return this.delegate.getKeyId();
    }

    @Override
    public Region getRegion() {
        return this.delegate.getRegion();
    }
}

