/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import com.fasterxml.jackson.core.JsonGenerator;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.SecurityInfoNotReadyException;
import oracle.nosql.driver.httpclient.HttpClient;
import oracle.nosql.driver.iam.AuthenticationProfileProvider;
import oracle.nosql.driver.iam.InstanceMetadataHelper;
import oracle.nosql.driver.iam.SecurityTokenSupplier;
import oracle.nosql.driver.iam.SessionKeyPairSupplier;
import oracle.nosql.driver.iam.Utils;
import oracle.nosql.driver.util.CheckNull;
import oracle.nosql.driver.util.HttpRequestUtil;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;

class OkeWorkloadIdentityProvider
implements AuthenticationProfileProvider,
Region.RegionProvider,
SecurityTokenSupplier.SecurityTokenBasedProvider {
    private static final String DEFAULT_KUBERNETES_SERVICE_ACCOUNT_CERT_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private static final String KUBERNETES_SERVICE_ACCOUNT_CERT_PATH_ENV = "OCI_KUBERNETES_SERVICE_ACCOUNT_CERT_PATH";
    private static final String KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private static final String OCI_REGION_METADATA = "OCI_REGION_METADATA";
    private static final String REGION_ID = "regionIdentifier";
    private static final int PROXYMUX_SERVER_PORT = 12250;
    private static final String OPC_REQUEST_ID_HEADER = "opc-request-id";
    private static final String JWT_FORMAT = "Bearer %s";
    private static final int timeoutMs = 5000;
    static final String KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    static final String TOKEN_PATH = "/resourcePrincipalSessionTokens";
    private final SessionKeyPairSupplier.DefaultSessionKeySupplier sessionKeySupplier;
    private final String serviceAccountToken;
    private final File serviceAccountTokenFile;
    private final URI tokenURL;
    private final Region region;
    private final Logger logger;
    private long minTokenLifetime;
    private HttpClient okeTokenClient;

    OkeWorkloadIdentityProvider(String serviceAccountToken, File serviceAccountTokenFile, Logger logger) {
        if (serviceAccountToken != null && serviceAccountTokenFile != null) {
            throw new IllegalArgumentException("Must not specify both service account token string and file");
        }
        this.serviceAccountToken = serviceAccountToken;
        this.serviceAccountTokenFile = serviceAccountTokenFile != null ? serviceAccountTokenFile : new File(KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH);
        this.sessionKeySupplier = new SessionKeyPairSupplier.DefaultSessionKeySupplier(new SessionKeyPairSupplier.JDKKeyPairSupplier());
        this.logger = logger != null ? logger : Logger.getLogger(this.getClass().getName());
        this.tokenURL = OkeWorkloadIdentityProvider.getURL();
        this.region = OkeWorkloadIdentityProvider.getRegionFromInstance(logger);
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public String getKeyId() {
        return "ST$" + this.getSecurityToken();
    }

    @Override
    public InputStream getPrivateKey() {
        return new ByteArrayInputStream(this.sessionKeySupplier.getPrivateKeyBytes());
    }

    @Override
    public char[] getPassphraseCharacters() {
        return null;
    }

    @Override
    public void setMinTokenLifetime(long lifeTimeMS) {
        this.minTokenLifetime = lifeTimeMS;
    }

    @Override
    public void prepare(NoSQLHandleConfig config) {
        SslContext sslCtx;
        File kubernetesCaCertFile = new File(System.getenv(KUBERNETES_SERVICE_ACCOUNT_CERT_PATH_ENV) != null ? System.getenv(KUBERNETES_SERVICE_ACCOUNT_CERT_PATH_ENV) : DEFAULT_KUBERNETES_SERVICE_ACCOUNT_CERT_PATH);
        if (!kubernetesCaCertFile.exists()) {
            throw new IllegalArgumentException("Kubernetes service account ca cert doesn't exist.");
        }
        try {
            sslCtx = SslContextBuilder.forClient().trustManager(kubernetesCaCertFile).build();
        }
        catch (SSLException se) {
            throw new IllegalArgumentException("Error building SSL context from Kubernetes service account ca cert ", se);
        }
        this.okeTokenClient = HttpClient.createMinimalClient(this.tokenURL.getHost(), this.tokenURL.getPort(), sslCtx, config.getSSLHandshakeTimeout(), "OkeWorkloadIdentityResourcePrincipalsTokenClient", this.logger);
        this.okeTokenClient.disableEndpointIdentification();
    }

    @Override
    public void close() {
        if (this.okeTokenClient != null) {
            this.okeTokenClient.shutdown();
        }
    }

    private static URI getURL() {
        String host = System.getenv().get(KUBERNETES_SERVICE_HOST);
        if (host == null) {
            throw new IllegalArgumentException("Invalid environment variable KUBERNETES_SERVICE_HOST, please contact OKE Foundation team for help.");
        }
        return URI.create("https://" + host + ":" + 12250 + TOKEN_PATH);
    }

    private String getSecurityToken() {
        this.sessionKeySupplier.refreshKeys();
        String saToken = this.getServiceAccountToken();
        KeyPair keyPair = this.sessionKeySupplier.getKeyPair();
        CheckNull.requireNonNullIAE(keyPair, "Keypair for session not provided");
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        CheckNull.requireNonNullIAE(publicKey, "Public key not present");
        String requestId = Utils.generateOpcRequestId();
        Utils.logTrace(this.logger, "opc-request-id of token request: " + requestId);
        String body = OkeWorkloadIdentityProvider.getRequestBody(publicKey);
        CharBuffer charBuf = CharBuffer.wrap(body);
        ByteBuffer buf = StandardCharsets.UTF_8.encode(charBuf);
        byte[] payloadByte = new byte[buf.remaining()];
        buf.get(payloadByte);
        try {
            return this.getSecurityTokenFromProxymux(requestId, saToken, payloadByte);
        }
        catch (Exception e) {
            throw new SecurityInfoNotReadyException(e.getMessage(), e);
        }
    }

    private String getSecurityTokenFromProxymux(String requestId, String saToken, byte[] payloadByte) {
        HttpRequestUtil.HttpResponse response = HttpRequestUtil.doPostRequest(this.okeTokenClient, this.tokenURL.toString(), OkeWorkloadIdentityProvider.headers(saToken, requestId), payloadByte, 5000, this.logger);
        int responseCode = response.getStatusCode();
        String responseOutput = response.getOutput();
        if (responseCode > 299) {
            throw new IllegalStateException(String.format("Error getting security token from Kubernetes proxymux, status code %d, opc-request-id %s, response\n%s", responseCode, requestId, responseOutput));
        }
        responseOutput = responseOutput.replace("\"", "");
        Utils.logTrace(this.logger, "Token response " + responseOutput);
        String decoded = new String(Base64.getDecoder().decode(responseOutput), StandardCharsets.UTF_8);
        Utils.logTrace(this.logger, "Decoded Token " + decoded);
        String token = Utils.parseTokenResponse(decoded).substring(3);
        SecurityTokenSupplier.SecurityToken securityToken = new SecurityTokenSupplier.SecurityToken(token, this.sessionKeySupplier);
        securityToken.validate(this.minTokenLifetime, this.logger);
        return securityToken.getSecurityToken();
    }

    private String getServiceAccountToken() {
        String token = this.serviceAccountToken;
        if (token == null) {
            try {
                token = new String(Files.readAllBytes(this.serviceAccountTokenFile.toPath()));
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Kubernetes service account token unavailable.", ioe);
            }
        }
        Map<String, String> tokenClaims = Utils.parseToken(token);
        String exp = tokenClaims.get("exp");
        long expiryMS = -1L;
        if (exp != null) {
            expiryMS = Long.parseLong(exp) * 1000L;
        }
        if (exp == null || expiryMS == -1L) {
            throw new IllegalArgumentException("No expiration info in Kubernetes service account:\n" + token);
        }
        if (expiryMS < System.currentTimeMillis()) {
            throw new IllegalArgumentException("Kubernetes service account token expired.");
        }
        return token;
    }

    private static String getRequestBody(RSAPublicKey publicKey) {
        try {
            String podKey = new String(Base64.getEncoder().encode(publicKey.getEncoded()), StandardCharsets.UTF_8);
            StringWriter sw = new StringWriter();
            try (JsonGenerator gen = Utils.createGenerator(sw);){
                gen.writeStartObject();
                gen.writeStringField("podKey", podKey);
                gen.writeEndObject();
            }
            return sw.toString();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error getting federation request body", ioe);
        }
    }

    private static HttpHeaders headers(String token, String opcRequestId) {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        return headers.set("Content-Type", (Object)"application/json; charset=UTF-8").set(OPC_REQUEST_ID_HEADER, (Object)opcRequestId).set("Authorization", (Object)String.format(JWT_FORMAT, token));
    }

    private static Region getRegionFromInstance(Logger logger) {
        String regionId = null;
        String regionMetadata = System.getenv(OCI_REGION_METADATA);
        if (regionMetadata != null) {
            FieldValue jsonMetadata = FieldValue.createFromJson(regionMetadata, null);
            if (!(jsonMetadata instanceof MapValue)) {
                throw new IllegalArgumentException("Invalid format of OCI_REGION_METADATA: " + regionMetadata);
            }
            regionId = ((MapValue)jsonMetadata).getString(REGION_ID);
        } else {
            InstanceMetadataHelper.InstanceMetadata instanceMetadata = InstanceMetadataHelper.fetchMetadata(5000, logger);
            regionId = instanceMetadata.getRegion();
        }
        return Region.fromRegionId(regionId);
    }
}

