/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.function.Supplier;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.iam.AuthenticationProfileProvider;
import oracle.nosql.driver.iam.OCIConfigFileReader;
import oracle.nosql.driver.iam.PrivateKeyFileSupplier;
import oracle.nosql.driver.iam.Utils;
import oracle.nosql.driver.util.CheckNull;

class SessionTokenProvider
implements AuthenticationProfileProvider,
Region.RegionProvider {
    private final String sessionTokenFilePath;
    private final String tenantId;
    private final Supplier<InputStream> privateKeySupplier;
    private final char[] passphrase;
    private final Region region;

    SessionTokenProvider() {
        this(OCIConfigFileReader.DEFAULT_FILE_PATH, "DEFAULT");
    }

    SessionTokenProvider(String profile) {
        this(OCIConfigFileReader.DEFAULT_FILE_PATH, profile);
    }

    SessionTokenProvider(String configFilePath, String profile) {
        OCIConfigFileReader.OCIConfigFile configFile;
        try {
            configFile = OCIConfigFileReader.parse(configFilePath, profile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error parsing config file " + configFilePath + ": " + e.getMessage());
        }
        this.sessionTokenFilePath = configFile.get("security_token_file");
        CheckNull.requireNonNullIAE(this.sessionTokenFilePath, OCIConfigFileReader.missing("security_token_file"));
        this.tenantId = configFile.get("tenancy");
        CheckNull.requireNonNullIAE(this.tenantId, OCIConfigFileReader.missing("tenancy"));
        String keyFilePath = configFile.get("key_file");
        CheckNull.requireNonNullIAE(this.tenantId, OCIConfigFileReader.missing("key_file"));
        this.privateKeySupplier = new PrivateKeyFileSupplier(new File(Utils.expandUserHome(keyFilePath)));
        this.region = OCIConfigFileReader.getRegionFromConfigFile(configFile);
        String passphraseString = configFile.get("pass_phrase");
        this.passphrase = passphraseString != null ? passphraseString.toCharArray() : null;
    }

    private String refreshAndGetTokenInternal() {
        File sessionTokenFile = new File(Utils.expandUserHome(this.sessionTokenFilePath));
        StringBuilder token = new StringBuilder();
        try (Scanner reader = new Scanner(sessionTokenFile);){
            while (reader.hasNextLine()) {
                token.append(reader.nextLine());
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Session token file " + this.sessionTokenFilePath + " not found");
        }
        return token.toString();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public String getKeyId() {
        return "ST$" + this.refreshAndGetTokenInternal();
    }

    @Override
    public InputStream getPrivateKey() {
        return this.privateKeySupplier.get();
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.passphrase;
    }
}

