/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.iam.CertificateSupplier;
import oracle.nosql.driver.iam.UserAuthenticationProfileProvider;
import oracle.nosql.driver.iam.pki.Pem;
import oracle.nosql.driver.util.CheckNull;

class Utils {
    private static final JsonFactory factory = new JsonFactory();
    static final String RSA = "rsa-sha256";
    static final String RSA_JVM_NAME = "SHA256withRSA";
    static final int SINGATURE_VERSION = 1;
    static final String HEADER_DELIMITER = ": ";
    static String SIGNATURE_HEADER_FORMAT = "Signature headers=\"%s\",keyId=\"%s\",algorithm=\"%s\",signature=\"%s\",version=\"%s\"";
    static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final Pattern OCID_PATTERN = Pattern.compile("^([0-9a-zA-Z-_]+[.:])([0-9a-zA-Z-_]*[.:]){3,}([0-9a-zA-Z-_]+)$");
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final int BUF_SIZE = 2048;
    private static final String[] FIELDS = new String[]{"exp", "jwk", "n", "e", "res_compartment", "res_tenant"};

    Utils() {
    }

    static String getIAMURL(String regionIdOrCode) {
        Region region = Region.fromRegionIdOrCode(regionIdOrCode);
        if (region != null) {
            return region.endpointForService("auth", Region.getAuthEndpointFormat());
        }
        return null;
    }

    static boolean isValidOcid(String ocid) {
        return OCID_PATTERN.matcher(ocid).matches();
    }

    static String createKeyId(String tenantId, String userId, String fingerprint) {
        return String.format("%s/%s/%s", tenantId, userId, fingerprint);
    }

    static String createKeyId(UserAuthenticationProfileProvider prov) {
        return Utils.createKeyId(prov.getTenantId(), prov.getUserId(), prov.getFingerprint());
    }

    static String expandUserHome(String path) {
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            return System.getProperty("user.home") + Utils.correctPath(Utils.isWindows(), path.substring(1));
        }
        return path;
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.indexOf("Windows") != -1;
    }

    private static String correctPath(boolean isWindows, String path) {
        if (isWindows) {
            path = path.replace('/', '\\');
        }
        return path;
    }

    static SimpleDateFormat createFormatter() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat;
    }

    static String sign(String signingContent, PrivateKey key) throws Exception {
        Signature signature = Signature.getInstance(RSA_JVM_NAME);
        signature.initSign(key);
        signature.update(signingContent.getBytes(StandardCharsets.UTF_8));
        byte[] bytes = signature.sign();
        return new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
    }

    static byte[] toByteArray(RSAPrivateKey key) {
        return Pem.encoder().with(Pem.Format.LEGACY).encode(key);
    }

    static String base64EncodeNoChunking(RSAPublicKey publicKey) {
        return new String(Base64.getMimeEncoder().encode(publicKey.getEncoded()), StandardCharsets.UTF_8);
    }

    static String base64EncodeNoChunking(CertificateSupplier.X509CertificateKeyPair keyPair) {
        return new String(Base64.getMimeEncoder().encode(Utils.getEncodedCertificate(keyPair.getRawCertificate())), StandardCharsets.UTF_8);
    }

    static String getFingerPrint(CertificateSupplier.X509CertificateKeyPair keyPair) {
        CheckNull.requireNonNullIAE(keyPair.getRawCertificate(), "Unable to get certificate finger print, raw certificate is null");
        try {
            String pemCert = keyPair.getRawCertificate();
            byte[] encodedCertificate = Utils.getEncodedCertificate(pemCert);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(encodedCertificate);
            String fingerprint = Utils.getHex(md.digest());
            return Utils.formatFingerPrint(fingerprint);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unknown error getting certificate fingerprint", e);
        }
    }

    private static byte[] getEncodedCertificate(String pemCertificate) {
        return Base64.getMimeDecoder().decode(pemCertificate.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", ""));
    }

    private static String formatFingerPrint(String fingerprint) {
        int length = fingerprint.length();
        char[] format = new char[length * 3 / 2 - 1];
        int j = 0;
        for (int i = 0; i < length - 2; i += 2) {
            format[j++] = fingerprint.charAt(i);
            format[j++] = fingerprint.charAt(i + 1);
            format[j++] = 58;
        }
        format[j++] = fingerprint.charAt(length - 2);
        format[j] = fingerprint.charAt(length - 1);
        return String.valueOf(format);
    }

    private static String getHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    static String getTenantId(X509Certificate certificate) {
        CheckNull.requireNonNullIAE(certificate, "Unable to get tenant id, certificate is null");
        X500Principal principal = certificate.getSubjectX500Principal();
        String name = principal.getName();
        String tenantId = Utils.getValue(name, "OU", "opc-tenant");
        if (tenantId == null) {
            tenantId = Utils.getValue(name, "OU", "opc-identity");
        }
        if (tenantId != null) {
            return tenantId;
        }
        throw new IllegalStateException("The certificate used by instance principal does not contain tenant id.");
    }

    private static String getValue(String name, String type, String key) {
        try {
            LdapName ldapName = new LdapName(name);
            String prefix = key + ":";
            for (Rdn rdn : ldapName.getRdns()) {
                Attribute attribute;
                String rdnType = rdn.getType();
                if (!type.equalsIgnoreCase(rdnType) || (attribute = rdn.toAttributes().get(type)) == null) continue;
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMore()) {
                    String text;
                    Object value = values.next();
                    if (value == null || !(text = value.toString().trim()).startsWith(prefix)) continue;
                    return text.substring(prefix.length());
                }
            }
            return null;
        }
        catch (NamingException e) {
            throw new IllegalStateException("Error parsing the certificate name", e);
        }
    }

    static String readStream(InputStream inputStream) throws IOException {
        int read;
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[2048];
        while ((read = reader.read(buf)) != -1) {
            sb.append(buf, 0, read);
        }
        return sb.toString();
    }

    static RSAPublicKey toPublicKey(String modulus, String exponent) {
        try {
            Base64.Decoder decoder = Base64.getUrlDecoder();
            RSAPublicKey key = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(new BigInteger(1, decoder.decode(modulus.getBytes())), new BigInteger(1, decoder.decode(exponent.getBytes()))));
            return key;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error build public key from JWK", ex);
        }
    }

    static String computeBodySHA256(byte[] body) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(body);
            byte[] hash = digest.digest();
            return new String(Base64.getEncoder().encodeToString(hash));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm SHA-256 unavailable", e);
        }
    }

    static JsonParser createParser(String json) throws IOException {
        return factory.createParser(json);
    }

    static JsonGenerator createGenerator(StringWriter sw) throws IOException {
        return factory.createGenerator((Writer)sw);
    }

    static String findField(String json, JsonParser parser, String ... name) throws IOException {
        JsonToken token;
        List<String> fieldsList = Arrays.asList(name);
        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.START_OBJECT || token == JsonToken.END_OBJECT || token == JsonToken.VALUE_STRING) continue;
            String fieldName = parser.getCurrentName();
            if (fieldName == null) {
                throw new IllegalStateException("Null token or field name found in JSON " + json);
            }
            if (token != JsonToken.FIELD_NAME) continue;
            if (fieldsList.stream().anyMatch(str -> str.trim().equals(fieldName))) {
                return fieldName;
            }
            token = parser.nextToken();
            if (token != JsonToken.START_ARRAY) continue;
            while (parser.nextToken() != JsonToken.END_ARRAY) {
            }
        }
        return null;
    }

    static String parseTokenResponse(String response) {
        try {
            JsonParser parser = Utils.createParser(response);
            if (parser.getCurrentToken() == null) {
                parser.nextToken();
            }
            while (parser.getCurrentToken() != null) {
                String field = Utils.findField(response, parser, "token");
                if (field == null) continue;
                parser.nextToken();
                return parser.getText();
            }
            throw new IllegalStateException("Unable to find security token in " + response);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error parsing security token " + response + " " + ioe.getMessage());
        }
    }

    static Map<String, String> parseToken(String token) {
        if (token == null) {
            return null;
        }
        String[] jwt = Utils.splitJWT(token);
        String claimJson = new String(Base64.getUrlDecoder().decode(jwt[1]), StandardCharsets.UTF_8);
        try {
            JsonParser parser = Utils.createParser(claimJson);
            HashMap<String, String> results = new HashMap<String, String>();
            Utils.parse(token, parser, results);
            String jwkString = (String)results.get("jwk");
            if (jwkString == null) {
                return results;
            }
            parser = Utils.createParser(jwkString);
            Utils.parse(token, parser, results);
            return results;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error parsing security token " + ioe.getMessage());
        }
    }

    private static void parse(String json, JsonParser parser, Map<String, String> reults) throws IOException {
        if (parser.getCurrentToken() == null) {
            parser.nextToken();
        }
        while (parser.getCurrentToken() != null) {
            String field = Utils.findField(json, parser, FIELDS);
            if (field == null) continue;
            parser.nextToken();
            reults.put(field, parser.getText());
        }
    }

    private static String[] splitJWT(String jwt) {
        int dot1 = jwt.indexOf(".");
        int dot2 = jwt.indexOf(".", dot1 + 1);
        int dot3 = jwt.indexOf(".", dot2 + 1);
        if (dot1 == -1 || dot2 == -1 || dot3 != -1) {
            throw new IllegalArgumentException("Given string is not in the valid access token format");
        }
        String[] parts = new String[]{jwt.substring(0, dot1), jwt.substring(dot1 + 1, dot2), jwt.substring(dot2 + 1)};
        return parts;
    }

    static String generateOpcRequestId() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    static void logTrace(Logger logger, String message) {
        if (logger != null) {
            logger.log(Level.FINE, message);
        }
    }

    static void logError(Logger logger, String message) {
        if (logger != null) {
            logger.log(Level.WARNING, message);
        }
    }
}

