/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam.pki;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import oracle.nosql.driver.iam.pki.Eraser;

class OpenSslPbeSecretKeyGenerator {
    private final MessageDigest digest;
    private final byte[] password;
    private final byte[] salt;
    private final int keyLength;

    private OpenSslPbeSecretKeyGenerator(Builder builder) {
        this.digest = builder.digest;
        this.password = builder.password;
        this.salt = builder.salt;
        this.keyLength = builder.keyLength;
    }

    private static byte[] toBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Eraser.erase(byteBuffer);
        return bytes;
    }

    static Builder builder() {
        return new Builder();
    }

    byte[] generate() {
        int bytesNeeded = this.keyLength / 8;
        byte[] key = new byte[bytesNeeded];
        int offset = 0;
        while (true) {
            this.digest.update(this.password, 0, this.password.length);
            this.digest.update(this.salt, 0, this.salt.length);
            byte[] digested = this.digest.digest();
            int len = bytesNeeded > digested.length ? digested.length : bytesNeeded;
            System.arraycopy(digested, 0, key, offset, len);
            offset += len;
            if ((bytesNeeded -= len) == 0) break;
            this.digest.reset();
        }
        return key;
    }

    static final class Builder {
        private MessageDigest digest;
        private byte[] password;
        private byte[] salt;
        private int keyLength;

        private Builder() {
            try {
                this.digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }

        Builder digest(MessageDigest digest) {
            this.digest = digest;
            return this;
        }

        Builder password(char[] password) {
            this.password = OpenSslPbeSecretKeyGenerator.toBytes(password);
            return this;
        }

        Builder salt(byte[] salt) {
            this.salt = salt;
            return this;
        }

        Builder keyLength(int keyLength) {
            this.keyLength = keyLength;
            return this;
        }

        OpenSslPbeSecretKeyGenerator build() {
            return new OpenSslPbeSecretKeyGenerator(this);
        }
    }
}

