/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.Durability;
import oracle.nosql.driver.FieldRange;
import oracle.nosql.driver.ops.DurableRequest;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;
import oracle.nosql.driver.values.MapValue;

public class MultiDeleteRequest
extends DurableRequest {
    private MapValue key;
    private byte[] continuationKey;
    private FieldRange range;
    private int maxWriteKB;

    public MultiDeleteRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public MultiDeleteRequest setTableName(String tableName) {
        super.setTableNameInternal(tableName);
        return this;
    }

    public MapValue getKey() {
        return this.key;
    }

    public MultiDeleteRequest setKey(MapValue key) {
        this.key = key;
        return this;
    }

    public FieldRange getRange() {
        return this.range;
    }

    public MultiDeleteRequest setRange(FieldRange range) {
        this.range = range;
        return this;
    }

    public int getMaxWriteKB() {
        return this.maxWriteKB;
    }

    public MultiDeleteRequest setMaxWriteKB(int maxWriteKB) {
        if (maxWriteKB < 0) {
            throw new IllegalArgumentException("maxWriteKB must be >= 0");
        }
        this.maxWriteKB = maxWriteKB;
        return this;
    }

    public byte[] getContinuationKey() {
        return this.continuationKey;
    }

    public MultiDeleteRequest setContinuationKey(byte[] continuationKey) {
        this.continuationKey = continuationKey;
        return this;
    }

    public MultiDeleteRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    public MultiDeleteRequest setDurability(Durability durability) {
        this.setDurabilityInternal(durability);
        return this;
    }

    public MultiDeleteRequest setNamespace(String namespace) {
        super.setNamespaceInternal(namespace);
        return this;
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createMultiDeleteSerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createMultiDeleteDeserializer();
    }

    @Override
    public String getTypeName() {
        return "MultiDelete";
    }

    @Override
    public void validate() {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("MultiDeleteRequest requires table name");
        }
        if (this.key == null) {
            throw new IllegalArgumentException("MultiDeleteRequest requires a key");
        }
        if (this.range != null) {
            this.range.validate();
        }
    }

    @Override
    public boolean doesReads() {
        return true;
    }

    @Override
    public boolean doesWrites() {
        return true;
    }
}

