/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.nosql.driver.NoSQLHandle;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.QueryResult;
import oracle.nosql.driver.ops.Result;
import oracle.nosql.driver.ops.RetryStats;
import oracle.nosql.driver.values.MapValue;

public class QueryIterableResult
extends Result
implements Iterable<MapValue>,
AutoCloseable {
    private final QueryRequest request;
    private Set<QueryResultIterator> unclosedIters;
    private final NoSQLHandle handle;
    private boolean firstIteratorCall = true;
    private int readKB;
    private int readUnits;
    private int writeKB;
    private int writeUnits;

    public QueryIterableResult(QueryRequest request, NoSQLHandle handle) {
        assert (request != null) : "request should not be null";
        assert (handle != null) : "handle should not be null";
        if (request.getContKey() != null) {
            throw new IllegalArgumentException("A new QueryRequest is required for a QueryIterableResult.");
        }
        this.request = request;
        this.handle = handle;
    }

    @Override
    public Iterator<MapValue> iterator() {
        QueryResultIterator resultIterator;
        if (this.unclosedIters == null) {
            this.unclosedIters = new HashSet<QueryResultIterator>();
        }
        if (this.firstIteratorCall) {
            resultIterator = new QueryResultIterator(this.request);
            this.firstIteratorCall = false;
        } else {
            QueryRequest requestCopy = this.request.copy();
            resultIterator = new QueryResultIterator(requestCopy);
        }
        this.unclosedIters.add(resultIterator);
        return resultIterator;
    }

    private void removeTracking(QueryResultIterator iter) {
        if (this.unclosedIters != null) {
            this.unclosedIters.remove(iter);
        }
    }

    public int getReadKB() {
        return this.readKB;
    }

    public int getWriteKB() {
        return this.writeKB;
    }

    public int getReadUnits() {
        return this.readUnits;
    }

    public int getWriteUnits() {
        return this.writeUnits;
    }

    @Override
    public void close() {
        if (this.unclosedIters != null) {
            this.unclosedIters.forEach(iter -> iter.close());
        }
    }

    private class QueryResultIterator
    implements Iterator<MapValue> {
        final QueryRequest internalRequest;
        Iterator<MapValue> partialResultsIterator;
        boolean closed = false;

        QueryResultIterator(QueryRequest queryRequest) {
            this.internalRequest = queryRequest;
        }

        private void compute() {
            QueryResult internalResult;
            if (this.partialResultsIterator == null) {
                internalResult = QueryIterableResult.this.handle.query(this.internalRequest);
                List<MapValue> partialResults = internalResult.getResults();
                this.partialResultsIterator = partialResults.iterator();
                this.setStats(internalResult);
            }
            while (!this.partialResultsIterator.hasNext() && !this.internalRequest.isDone()) {
                internalResult = QueryIterableResult.this.handle.query(this.internalRequest);
                this.partialResultsIterator = internalResult.getResults().iterator();
                this.setStats(internalResult);
            }
            if (this.internalRequest.isDone() && !this.partialResultsIterator.hasNext()) {
                this.close();
            }
        }

        private void setStats(QueryResult internalResult) {
            QueryIterableResult.this.readKB = QueryIterableResult.this.readKB + internalResult.getReadKB();
            QueryIterableResult.this.readUnits = QueryIterableResult.this.readUnits + internalResult.getReadUnits();
            QueryIterableResult.this.writeKB = QueryIterableResult.this.writeKB + internalResult.getWriteKB();
            QueryIterableResult.this.writeUnits = QueryIterableResult.this.writeUnits + internalResult.getWriteUnits();
            QueryIterableResult.this.setRateLimitDelayedMs(QueryIterableResult.this.getRateLimitDelayedMs() + internalResult.getRateLimitDelayedMs());
            QueryIterableResult.this.setReadKB(QueryIterableResult.this.getReadKB() + internalResult.getReadKB());
            QueryIterableResult.this.setReadUnits(QueryIterableResult.this.getReadUnits() + internalResult.getReadUnits());
            QueryIterableResult.this.setWriteKB(QueryIterableResult.this.getWriteKB() + internalResult.getWriteKB());
            if (internalResult.getRetryStats() != null) {
                if (QueryIterableResult.this.getRetryStats() == null) {
                    QueryIterableResult.this.setRetryStats(new RetryStats());
                }
                QueryIterableResult.this.getRetryStats().addStats(internalResult.getRetryStats());
            }
        }

        @Override
        public boolean hasNext() {
            if (this.closed) {
                return false;
            }
            this.compute();
            return this.partialResultsIterator.hasNext();
        }

        @Override
        public MapValue next() {
            if (this.closed) {
                throw new NoSuchElementException("Iterator already closed.");
            }
            this.compute();
            return this.partialResultsIterator.next();
        }

        public void close() {
            this.closed = true;
            this.internalRequest.close();
            QueryIterableResult.this.removeTracking(this);
        }
    }
}

