/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import java.util.List;
import java.util.Map;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.Result;
import oracle.nosql.driver.query.QueryDriver;
import oracle.nosql.driver.query.VirtualScan;
import oracle.nosql.driver.values.MapValue;

public class QueryResult
extends Result {
    private final QueryRequest request;
    private List<MapValue> results;
    private byte[] continuationKey;
    private boolean reachedLimit;
    private boolean isComputed;
    private boolean isInPhase1;
    private int[] pids;
    private int[] numResultsPerPid;
    private byte[][] continuationKeys;
    private VirtualScan[] virtualScans;
    private Map<String, String> queryTraces;

    public QueryResult(QueryRequest req) {
        this(req, true);
    }

    public QueryResult(QueryRequest req, boolean computed) {
        this.request = req;
        this.isComputed = computed;
    }

    public QueryResult setComputed(boolean v) {
        this.isComputed = v;
        return this;
    }

    public QueryRequest getRequest() {
        return this.request;
    }

    public boolean reachedLimit() {
        return this.reachedLimit;
    }

    public QueryResult setReachedLimit(boolean v) {
        this.reachedLimit = v;
        return this;
    }

    public QueryResult setPids(int[] pids) {
        this.pids = pids;
        return this;
    }

    public int getNumPids() {
        return this.pids == null ? 0 : this.pids.length;
    }

    public int getPid(int i) {
        return this.pids[i];
    }

    public QueryResult setNumResultsPerPid(int[] v) {
        this.numResultsPerPid = v;
        return this;
    }

    public int getNumPartitionResults(int i) {
        return this.numResultsPerPid[i];
    }

    public byte[] getPartitionContKey(int i) {
        return this.continuationKeys[i];
    }

    public QueryResult setPartitionContKeys(byte[][] keys) {
        this.continuationKeys = keys;
        return this;
    }

    public QueryResult setIsInPhase1(boolean v) {
        this.isInPhase1 = v;
        return this;
    }

    public boolean isInPhase1() {
        return this.isInPhase1;
    }

    void compute() {
        if (this.isComputed) {
            return;
        }
        QueryDriver driver = this.request.getDriver();
        driver.compute(this);
        this.isComputed = true;
    }

    public List<MapValue> getResultsInternal() {
        return this.results;
    }

    public List<MapValue> getResults() {
        this.compute();
        return this.results;
    }

    public QueryResult setResults(List<MapValue> results) {
        this.results = results;
        return this;
    }

    public byte[] getContinuationKey() {
        this.compute();
        return this.continuationKey;
    }

    public QueryResult setContinuationKey(byte[] continuationKey) {
        this.continuationKey = continuationKey;
        return this;
    }

    public VirtualScan[] getVirtualScans() {
        return this.virtualScans;
    }

    public void setVirtualScans(VirtualScan[] vs) {
        this.virtualScans = vs;
    }

    public void setQueryTraces(Map<String, String> traces) {
        this.queryTraces = traces;
    }

    public Map<String, String> getQueryTraces() {
        return this.queryTraces;
    }

    public int getReadKB() {
        this.compute();
        return super.getReadKBInternal();
    }

    public int getWriteKB() {
        this.compute();
        return super.getWriteKBInternal();
    }

    public int getReadUnits() {
        this.compute();
        return super.getReadUnitsInternal();
    }

    public int getWriteUnits() {
        this.compute();
        return super.getWriteUnitsInternal();
    }

    public String toString() {
        this.compute();
        if (this.results == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Number of query results: ").append(this.results.size());
        for (MapValue res : this.results) {
            sb.append("\n").append(res);
        }
        sb.append("\n");
        return sb.toString();
    }
}

