/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import java.util.Collections;
import java.util.Map;
import oracle.nosql.driver.ops.Result;
import oracle.nosql.driver.values.TimestampValue;

public class ReplicaStatsResult
extends Result {
    private String tableName;
    private long nextStartTime;
    private Map<String, ReplicaStats[]> statsRecords;

    public String getTableName() {
        return this.tableName;
    }

    public long getNextStartTime() {
        return this.nextStartTime;
    }

    public Map<String, ReplicaStats[]> getStatsRecord() {
        return this.statsRecords != null ? this.statsRecords : Collections.emptyMap();
    }

    public ReplicaStatsResult setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public ReplicaStatsResult setNextStartTime(long nextStartTime) {
        this.nextStartTime = nextStartTime;
        return this;
    }

    public ReplicaStatsResult setStatsRecords(Map<String, ReplicaStats[]> records) {
        this.statsRecords = records;
        return this;
    }

    public static class ReplicaStats {
        public long collectionTimeMillis;
        public int replicaLag;

        public long getCollectionTime() {
            return this.collectionTimeMillis;
        }

        public String getCollectionTimeString() {
            return new TimestampValue(this.collectionTimeMillis).getString();
        }

        public int getReplicaLag() {
            return this.replicaLag;
        }
    }
}

