/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import java.util.HashMap;
import java.util.Map;

public class RetryStats {
    private int retries = 0;
    private int delayMs = 0;
    private Map<Class<? extends Throwable>, Integer> exceptionMap = new HashMap<Class<? extends Throwable>, Integer>();

    public void addException(Class<? extends Throwable> e) {
        this.addException(e, 1);
    }

    public void addException(Class<? extends Throwable> e, int n) {
        int i = this.getNumExceptions(e) + n;
        this.exceptionMap.put(e, i);
    }

    public void addDelayMs(int d) {
        this.delayMs += d;
    }

    public void incrementRetries() {
        ++this.retries;
    }

    public int getNumExceptions(Class<? extends Throwable> e) {
        Integer i = this.exceptionMap.get(e);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public int getDelayMs() {
        return this.delayMs;
    }

    public int getRetries() {
        return this.retries;
    }

    public void clear() {
        this.delayMs = 0;
        this.retries = 0;
        this.exceptionMap.clear();
    }

    public Map<Class<? extends Throwable>, Integer> getExceptionMap() {
        return this.exceptionMap;
    }

    public void addStats(RetryStats rs) {
        if (rs == null) {
            return;
        }
        this.delayMs += rs.getDelayMs();
        this.retries += rs.getRetries();
        Map<Class<? extends Throwable>, Integer> emap = rs.getExceptionMap();
        if (emap == null || emap.isEmpty()) {
            return;
        }
        for (Map.Entry<Class<? extends Throwable>, Integer> entry : emap.entrySet()) {
            int i = entry.getValue();
            Integer val = this.exceptionMap.get(entry.getKey());
            if (val != null) {
                i += val.intValue();
            }
            this.exceptionMap.put(entry.getKey(), i);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof RetryStats)) {
            return false;
        }
        RetryStats rs = (RetryStats)o;
        return this.retries == rs.retries && this.delayMs == rs.delayMs && this.exceptionMap.equals(rs.exceptionMap);
    }

    public int hashCode() {
        return this.retries + this.delayMs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("retries=").append(this.retries).append(" delayMs=").append(this.delayMs).append(" exceptionMap=").append(this.exceptionMap);
        return sb.toString();
    }
}

