/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.ops.Result;
import oracle.nosql.driver.values.TimestampValue;

public class TableUsageResult
extends Result {
    private String tableName;
    private TableUsage[] usageRecords;
    private int lastIndexReturned;

    public String getTableName() {
        return this.tableName;
    }

    public TableUsage[] getUsageRecords() {
        return this.usageRecords;
    }

    public int getLastReturnedIndex() {
        return this.lastIndexReturned;
    }

    public TableUsageResult setLastIndexReturned(int lastIndexReturned) {
        this.lastIndexReturned = lastIndexReturned;
        return this;
    }

    public TableUsageResult setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableUsageResult setUsageRecords(TableUsage[] records) {
        this.usageRecords = records;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GetTableUsageResult [table=").append(this.tableName).append("]");
        sb.append(" [tableUsage=[");
        if (this.usageRecords == null) {
            sb.append("null");
        } else {
            for (int i = 0; i < this.usageRecords.length; ++i) {
                this.usageRecords[i].toBuilder(sb);
                if (i >= this.usageRecords.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append("]]");
        return sb.toString();
    }

    public static class TableUsage {
        public long startTimeMillis;
        public int secondsInPeriod;
        public int readUnits;
        public int writeUnits;
        public int storageGB;
        public int readThrottleCount;
        public int writeThrottleCount;
        public int storageThrottleCount;
        public int maxShardUsagePercent;

        public long getStartTime() {
            return this.startTimeMillis;
        }

        public String getStartTimeString() {
            if (this.startTimeMillis == 0L) {
                return null;
            }
            return new TimestampValue(this.startTimeMillis).getString();
        }

        public int getSecondsInPeriod() {
            return this.secondsInPeriod;
        }

        public int getReadUnits() {
            return this.readUnits;
        }

        public int getWriteUnits() {
            return this.writeUnits;
        }

        public int getStorageGB() {
            return this.storageGB;
        }

        public int getReadThrottleCount() {
            return this.readThrottleCount;
        }

        public int getWriteThrottleCount() {
            return this.writeThrottleCount;
        }

        public int getStorageThrottleCount() {
            return this.storageThrottleCount;
        }

        public int getMaxShardUsagePercent() {
            return this.maxShardUsagePercent;
        }

        public void toBuilder(StringBuilder builder) {
            builder.append("TableUsage [startTimeMillis=");
            builder.append(this.startTimeMillis);
            builder.append(", secondsInPeriod=");
            builder.append(this.secondsInPeriod);
            builder.append(", readUnits=");
            builder.append(this.readUnits);
            builder.append(", writeUnits=");
            builder.append(this.writeUnits);
            builder.append(", storageGB=");
            builder.append(this.storageGB);
            builder.append(", readThrottleCount=");
            builder.append(this.readThrottleCount);
            builder.append(", writeThrottleCount=");
            builder.append(this.writeThrottleCount);
            builder.append(", storageThrottleCount=");
            builder.append(this.storageThrottleCount);
            builder.append(", maxShardUsagePercent=");
            builder.append(this.maxShardUsagePercent);
            builder.append("]");
        }
    }
}

