/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import oracle.nosql.driver.query.Compare;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.query.SortSpec;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.SizeOf;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.FieldValue;

public class FuncCollectIter
extends PlanIter {
    private final boolean theIsDistinct;
    private final PlanIter theInput;

    FuncCollectIter(ByteInputStream in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theIsDistinct = in.readBoolean();
        this.theInput = FuncCollectIter.deserializeIter(in, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FN_COLLECT;
    }

    @Override
    PlanIter getInputIter() {
        return this.theInput;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new CollectIterState(rcb));
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        CollectIterState state = (CollectIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more;
        while (more = this.theInput.next(rcb)) {
            FieldValue val = rcb.getRegVal(this.theInput.getResultReg());
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("Collecting value " + val);
            }
            this.aggregate(rcb, val);
        }
        return true;
    }

    void aggregate(RuntimeControlBlock rcb, FieldValue val) {
        CollectIterState state = (CollectIterState)rcb.getState(this.theStatePos);
        if (val.isNull() || val.isEMPTY()) {
            return;
        }
        if (this.theIsDistinct) {
            ArrayValue arr = (ArrayValue)val;
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                WrappedValue wval = new WrappedValue(arr.get(i));
                state.theValues.add(wval);
                long sz = wval.sizeof();
                rcb.incMemoryConsumption(sz);
                state.theMemoryConsumption += sz;
            }
        } else {
            ArrayValue arr = (ArrayValue)val;
            state.theArray.addAll(arr.iterator());
            long sz = arr.sizeof() + (long)(arr.size() * SizeOf.OBJECT_REF_OVERHEAD);
            rcb.incMemoryConsumption(sz);
            state.theMemoryConsumption += sz;
        }
    }

    @Override
    FieldValue getAggrValue(RuntimeControlBlock rcb, boolean reset) {
        ArrayValue res;
        CollectIterState state = (CollectIterState)rcb.getState(this.theStatePos);
        if (this.theIsDistinct) {
            res = new ArrayValue();
            Iterator<WrappedValue> iter = state.theValues.iterator();
            while (iter.hasNext()) {
                res.add(iter.next().theValue);
            }
        } else {
            res = state.theArray;
        }
        if (rcb.getRequest().inTestMode()) {
            res.sort(state.theComparator);
        }
        if (rcb.getTraceLevel() >= 3) {
            rcb.trace("Collected values " + res);
        }
        if (reset) {
            state.reset(this);
        }
        return res;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("\"distinct\" : ").append(this.theIsDistinct);
        sb.append(",\n");
        this.theInput.display(sb, formatter);
    }

    private class CollectIterState
    extends PlanIterState {
        final CompareFunction theComparator;
        ArrayValue theArray;
        HashSet<WrappedValue> theValues;
        long theMemoryConsumption;
        RuntimeControlBlock theRCB;

        CollectIterState(RuntimeControlBlock rcb) {
            this.theComparator = new CompareFunction(rcb);
            this.theArray = new ArrayValue();
            this.theValues = new HashSet(128);
            this.theRCB = rcb;
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theArray = new ArrayValue();
            this.theValues.clear();
            this.theRCB.decMemoryConsumption(this.theMemoryConsumption);
            this.theMemoryConsumption = 0L;
        }

        @Override
        public void close() {
            super.close();
            this.theArray = null;
            this.theValues = null;
        }
    }

    static class WrappedValue {
        public FieldValue theValue;

        WrappedValue(FieldValue value) {
            this.theValue = value;
        }

        public boolean equals(Object other) {
            WrappedValue o = (WrappedValue)other;
            return Compare.equal(this.theValue, o.theValue);
        }

        public int hashCode() {
            return Compare.hashcode(this.theValue);
        }

        public long sizeof() {
            return (long)(SizeOf.OBJECT_OVERHEAD + SizeOf.OBJECT_REF_OVERHEAD) + this.theValue.sizeof();
        }
    }

    static class CompareFunction
    implements Comparator<FieldValue> {
        final RuntimeControlBlock theRCB;
        final SortSpec theSortSpec;

        CompareFunction(RuntimeControlBlock rcb) {
            this.theRCB = rcb;
            this.theSortSpec = new SortSpec();
        }

        @Override
        public int compare(FieldValue v1, FieldValue v2) {
            return Compare.compareTotalOrder(this.theRCB, v1, v2, this.theSortSpec);
        }
    }
}

