/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import oracle.nosql.driver.query.AggrIterState;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryException;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NullValue;

public class FuncSizeIter
extends PlanIter {
    private final PlanIter theInput;

    FuncSizeIter(ByteInputStream in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInput = FuncSizeIter.deserializeIter(in, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FN_SIZE;
    }

    @Override
    PlanIter getInputIter() {
        return this.theInput;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new AggrIterState());
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        int size;
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more = this.theInput.next(rcb);
        if (!more) {
            state.done();
            return false;
        }
        FieldValue item = rcb.getRegVal(this.theInput.getResultReg());
        if (item.isNull()) {
            rcb.setRegVal(this.theResultReg, NullValue.getInstance());
            state.done();
            return true;
        }
        if (item.isArray()) {
            size = ((ArrayValue)item).size();
        } else if (item.isMap()) {
            size = ((MapValue)item).size();
        } else {
            throw new QueryException("Input to the size() function has wrong type\nExpected a complex item. Actual item type is:\n" + (Object)((Object)item.getType()), this.getLocation());
        }
        IntegerValue res = new IntegerValue(size);
        rcb.setRegVal(this.theResultReg, res);
        return true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }
}

