/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.nosql.driver.query.Compare;
import oracle.nosql.driver.query.FuncCollectIter;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.QueryStateException;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.SerializationUtil;
import oracle.nosql.driver.util.SizeOf;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NullValue;
import oracle.nosql.driver.values.NumberValue;

public class GroupIter
extends PlanIter {
    private static final FieldValue one = new LongValue(1L);
    private final PlanIter theInput;
    private final int theNumGBColumns;
    private final String[] theColumnNames;
    private final PlanIter.FuncCode[] theAggrFuncs;
    private final boolean theIsDistinct;
    private final boolean theRemoveProducedResult;
    private final boolean theCountMemory;

    public GroupIter(ByteInputStream in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInput = GroupIter.deserializeIter(in, serialVersion);
        this.theNumGBColumns = in.readInt();
        this.theColumnNames = SerializationUtil.readStringArray(in);
        int numAggrs = this.theColumnNames.length - this.theNumGBColumns;
        this.theAggrFuncs = new PlanIter.FuncCode[numAggrs];
        for (int i = 0; i < numAggrs; ++i) {
            short kvcode = in.readShort();
            this.theAggrFuncs[i] = PlanIter.FuncCode.valueOf(kvcode);
        }
        this.theIsDistinct = in.readBoolean();
        this.theRemoveProducedResult = in.readBoolean();
        this.theCountMemory = in.readBoolean();
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.GROUP;
    }

    @Override
    PlanIter getInputIter() {
        return this.theInput;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        GroupIterState state = new GroupIterState(rcb, this);
        rcb.setState(this.theStatePos, state);
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        GroupIterState state = (GroupIterState)rcb.getState(this.theStatePos);
        state.reset(this);
        this.theInput.reset(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        GroupIterState state = (GroupIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        while (true) {
            int i;
            if (state.theResultsIter != null) {
                if (state.theResultsIter.hasNext()) {
                    int i2;
                    Map.Entry<GroupTuple, AggrValue[]> tuple = state.theResultsIter.next();
                    GroupTuple gbTuple = tuple.getKey();
                    AggrValue[] aggrTuple = tuple.getValue();
                    MapValue res = new MapValue();
                    for (i2 = 0; i2 < this.theNumGBColumns; ++i2) {
                        res.put(this.theColumnNames[i2], gbTuple.theValues[i2]);
                    }
                    while (i2 < this.theColumnNames.length) {
                        FieldValue aggr = this.getAggrValue(rcb, state, aggrTuple, i2);
                        res.put(this.theColumnNames[i2], aggr);
                        ++i2;
                    }
                    rcb.setRegVal(this.theResultReg, res);
                    if (this.theRemoveProducedResult) {
                        state.theResultsIter.remove();
                    }
                    return true;
                }
                state.done();
                return false;
            }
            boolean more = this.theInput.next(rcb);
            if (!more) {
                if (rcb.reachedLimit()) {
                    return false;
                }
                if (this.theNumGBColumns == this.theColumnNames.length) {
                    state.done();
                    return false;
                }
                state.theResultsIter = state.theResults.entrySet().iterator();
                continue;
            }
            MapValue inTuple = (MapValue)rcb.getRegVal(this.theInput.getResultReg());
            for (i = 0; i < this.theNumGBColumns; ++i) {
                FieldValue colValue = inTuple.get(this.theColumnNames[i]);
                if (colValue.isEMPTY()) {
                    if (!this.theIsDistinct) break;
                    colValue = NullValue.getInstance();
                }
                state.theGBTuple.theValues[i] = colValue;
            }
            if (i < this.theNumGBColumns) continue;
            AggrValue[] aggrTuple = state.theResults.get(state.theGBTuple);
            if (aggrTuple == null) {
                int numAggrColumns = this.theColumnNames.length - this.theNumGBColumns;
                GroupTuple gbTuple = new GroupTuple(this.theNumGBColumns);
                aggrTuple = new AggrValue[numAggrColumns];
                long aggrTupleSize = 0L;
                for (i = 0; i < numAggrColumns; ++i) {
                    aggrTuple[i] = new AggrValue(this.theAggrFuncs[i]);
                    if (!this.theCountMemory) continue;
                    aggrTupleSize += aggrTuple[i].sizeof();
                }
                for (i = 0; i < this.theNumGBColumns; ++i) {
                    gbTuple.theValues[i] = state.theGBTuple.theValues[i];
                }
                if (this.theCountMemory) {
                    long sz = gbTuple.sizeof() + aggrTupleSize + (long)SizeOf.HASHMAP_ENTRY_OVERHEAD;
                    rcb.incMemoryConsumption(sz);
                }
                while (i < this.theColumnNames.length) {
                    this.aggregate(rcb, state, aggrTuple, i, inTuple.get(this.theColumnNames[i]));
                    ++i;
                }
                state.theResults.put(gbTuple, aggrTuple);
                if (rcb.getTraceLevel() >= 3) {
                    rcb.trace("Started new group:\n" + this.printResult(gbTuple, aggrTuple));
                }
                if (this.theNumGBColumns != this.theColumnNames.length) continue;
                MapValue res = new MapValue();
                for (i = 0; i < this.theNumGBColumns; ++i) {
                    res.put(this.theColumnNames[i], gbTuple.theValues[i]);
                }
                rcb.setRegVal(this.theResultReg, res);
                return true;
            }
            for (i = this.theNumGBColumns; i < this.theColumnNames.length; ++i) {
                this.aggregate(rcb, state, aggrTuple, i, inTuple.get(this.theColumnNames[i]));
            }
            if (rcb.getTraceLevel() < 3) continue;
            rcb.trace("Updated existing group:\n" + this.printResult(state.theGBTuple, aggrTuple));
        }
    }

    private void aggregate(RuntimeControlBlock rcb, GroupIterState state, AggrValue[] aggrValues, int column, FieldValue val) {
        AggrValue aggrValue = aggrValues[column - this.theNumGBColumns];
        PlanIter.FuncCode aggrKind = this.theAggrFuncs[column - this.theNumGBColumns];
        switch (aggrKind) {
            case FN_COUNT: {
                if (val.isNull()) {
                    return;
                }
                aggrValue.add(rcb, state, this.theCountMemory, one, rcb.getMathContext());
                return;
            }
            case FN_COUNT_NUMBERS: {
                if (val.isNull() || !val.isNumeric()) {
                    return;
                }
                aggrValue.add(rcb, state, this.theCountMemory, one, rcb.getMathContext());
                return;
            }
            case FN_COUNT_STAR: {
                aggrValue.add(rcb, state, this.theCountMemory, one, rcb.getMathContext());
                return;
            }
            case FN_SUM: {
                if (val.isNull()) {
                    return;
                }
                if (val.isNumeric()) {
                    aggrValue.add(rcb, state, this.theCountMemory, val, rcb.getMathContext());
                }
                return;
            }
            case FN_MIN: 
            case FN_MAX: {
                switch (val.getType()) {
                    case BINARY: 
                    case MAP: 
                    case ARRAY: 
                    case EMPTY: 
                    case NULL: 
                    case JSON_NULL: {
                        return;
                    }
                }
                FieldValue minmaxValue = (FieldValue)aggrValue.theValue;
                if (minmaxValue.isNull()) {
                    if (rcb.getTraceLevel() >= 3) {
                        rcb.trace("Setting min/max to " + val);
                    }
                    if (this.theCountMemory) {
                        rcb.incMemoryConsumption(val.sizeof() - minmaxValue.sizeof());
                    }
                    aggrValue.theValue = val;
                    return;
                }
                int cmp = Compare.compareAtomicsTotalOrder(rcb, minmaxValue, val);
                if (rcb.getTraceLevel() >= 3) {
                    rcb.trace("Compared values: \n" + minmaxValue + "\n" + val + "\ncomp res = " + cmp);
                }
                if (aggrKind == PlanIter.FuncCode.FN_MIN ? cmp <= 0 : cmp >= 0) {
                    return;
                }
                if (rcb.getTraceLevel() >= 3) {
                    rcb.trace("Setting min/max to " + val);
                }
                if (this.theCountMemory && val.getType() != minmaxValue.getType()) {
                    rcb.incMemoryConsumption(val.sizeof() - minmaxValue.sizeof());
                }
                aggrValue.theValue = val;
                return;
            }
            case FN_ARRAY_COLLECT: 
            case FN_ARRAY_COLLECT_DISTINCT: {
                aggrValue.collect(rcb, val, this.theCountMemory);
                return;
            }
        }
        throw new QueryStateException("Method not implemented for iterator " + (Object)((Object)aggrKind));
    }

    private FieldValue getAggrValue(RuntimeControlBlock rcb, GroupIterState state, AggrValue[] aggrTuple, int column) {
        AggrValue aggrValue = aggrTuple[column - this.theNumGBColumns];
        PlanIter.FuncCode aggrKind = this.theAggrFuncs[column - this.theNumGBColumns];
        if (aggrKind == PlanIter.FuncCode.FN_SUM && !aggrValue.theGotNumericInput) {
            return NullValue.getInstance();
        }
        if (aggrKind == PlanIter.FuncCode.FN_ARRAY_COLLECT) {
            ArrayValue collectArray = (ArrayValue)aggrValue.theValue;
            if (rcb.getRequest().inTestMode()) {
                collectArray.getArrayInternal().sort(state.theComparator);
            }
            return collectArray;
        }
        if (aggrKind == PlanIter.FuncCode.FN_ARRAY_COLLECT_DISTINCT) {
            ArrayValue collectArray = new ArrayValue();
            HashSet collectSet = (HashSet)aggrValue.theValue;
            Iterator iter = collectSet.iterator();
            while (iter.hasNext()) {
                collectArray.add(((FuncCollectIter.WrappedValue)iter.next()).theValue);
            }
            if (rcb.getRequest().inTestMode()) {
                collectArray.getArrayInternal().sort(state.theComparator);
            }
            return collectArray;
        }
        return (FieldValue)aggrValue.theValue;
    }

    private String printResult(GroupTuple gbTuple, AggrValue[] aggrValues) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (i = 0; i < gbTuple.theValues.length; ++i) {
            sb.append(gbTuple.theValues[i]);
            sb.append(" ");
        }
        sb.append("- ");
        for (i = 0; i < aggrValues.length; ++i) {
            sb.append(aggrValues[i].theValue);
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        formatter.indent(sb);
        sb.append("Grouping Columns : ");
        for (i = 0; i < this.theNumGBColumns; ++i) {
            sb.append(this.theColumnNames[i]);
            if (i >= this.theNumGBColumns - 1) continue;
            sb.append(", ");
        }
        sb.append("\n");
        formatter.indent(sb);
        sb.append("Aggregate Functions : ");
        for (i = 0; i < this.theAggrFuncs.length; ++i) {
            sb.append((Object)this.theAggrFuncs[i]);
            if (i >= this.theAggrFuncs.length - 1) continue;
            sb.append(",\n");
        }
        sb.append("\n");
        this.theInput.display(sb, formatter);
    }

    private static class GroupIterState
    extends PlanIterState {
        final FuncCollectIter.CompareFunction theComparator;
        final HashMap<GroupTuple, AggrValue[]> theResults;
        Iterator<Map.Entry<GroupTuple, AggrValue[]>> theResultsIter;
        GroupTuple theGBTuple;

        public GroupIterState(RuntimeControlBlock rcb, GroupIter iter) {
            this.theComparator = new FuncCollectIter.CompareFunction(rcb);
            this.theResults = new HashMap(4096);
            this.theGBTuple = new GroupTuple(iter.theNumGBColumns);
        }

        @Override
        public void done() {
            super.done();
            this.theResultsIter = null;
            this.theResults.clear();
            this.theGBTuple = null;
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theResultsIter = null;
            this.theResults.clear();
        }

        @Override
        public void close() {
            super.close();
            this.theResults.clear();
            this.theResultsIter = null;
            this.theGBTuple = null;
        }
    }

    private static class AggrValue {
        Object theValue;
        boolean theGotNumericInput;

        AggrValue(PlanIter.FuncCode aggrIterKind) {
            switch (aggrIterKind) {
                case FN_COUNT: 
                case FN_COUNT_NUMBERS: 
                case FN_COUNT_STAR: 
                case FN_SUM: {
                    this.theValue = new LongValue(0L);
                    break;
                }
                case FN_MIN: 
                case FN_MAX: {
                    this.theValue = NullValue.getInstance();
                    break;
                }
                case FN_ARRAY_COLLECT: {
                    this.theValue = new ArrayValue();
                    break;
                }
                case FN_ARRAY_COLLECT_DISTINCT: {
                    this.theValue = new HashSet();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        long sizeof() {
            long sz = SizeOf.OBJECT_OVERHEAD + SizeOf.OBJECT_REF_OVERHEAD + 1;
            if (this.theValue instanceof FieldValue) {
                sz += ((FieldValue)this.theValue).sizeof();
            } else {
                HashSet collectSet = (HashSet)this.theValue;
                Iterator iter = collectSet.iterator();
                while (iter.hasNext()) {
                    sz += (long)SizeOf.HASHSET_ENTRY_OVERHEAD + ((FuncCollectIter.WrappedValue)iter.next()).sizeof();
                }
            }
            return sz;
        }

        void collect(RuntimeControlBlock rcb, FieldValue val, boolean countMemory) {
            boolean isDistinct;
            if (val.isNull() || val.isEMPTY()) {
                return;
            }
            boolean bl = isDistinct = !(this.theValue instanceof FieldValue);
            if (isDistinct) {
                HashSet collectSet = (HashSet)this.theValue;
                ArrayValue arrval = (ArrayValue)val;
                for (FieldValue elem : arrval) {
                    FuncCollectIter.WrappedValue welem = new FuncCollectIter.WrappedValue(elem);
                    collectSet.add(welem);
                    if (!countMemory) continue;
                    rcb.incMemoryConsumption(welem.sizeof() + (long)SizeOf.HASHSET_ENTRY_OVERHEAD);
                }
            } else {
                ArrayValue collectArray = (ArrayValue)this.theValue;
                ArrayValue arrayVal = (ArrayValue)val;
                collectArray.addAll(arrayVal.iterator());
                if (countMemory) {
                    rcb.incMemoryConsumption(val.sizeof() + (long)(SizeOf.OBJECT_REF_OVERHEAD * arrayVal.size()));
                }
            }
        }

        void add(RuntimeControlBlock rcb, GroupIterState state, boolean countMemory, FieldValue val, MathContext ctx) {
            long sz = 0L;
            FieldValue sumValue = (FieldValue)this.theValue;
            block0 : switch (val.getType()) {
                case INTEGER: {
                    this.theGotNumericInput = true;
                    switch (sumValue.getType()) {
                        case LONG: {
                            long sum = ((LongValue)this.theValue).getValue();
                            ((LongValue)this.theValue).setValue(sum += (long)((IntegerValue)val).getValue());
                            break block0;
                        }
                        case DOUBLE: {
                            double sum = ((DoubleValue)this.theValue).getValue();
                            ((DoubleValue)this.theValue).setValue(sum += (double)((IntegerValue)val).getValue());
                            break block0;
                        }
                        case NUMBER: {
                            BigDecimal sum = ((NumberValue)this.theValue).getValue();
                            BigDecimal bd = new BigDecimal(((IntegerValue)val).getValue());
                            sum = sum.add(bd, ctx);
                            ((NumberValue)this.theValue).setValue(sum);
                            break block0;
                        }
                    }
                    assert (false);
                    break;
                }
                case LONG: {
                    this.theGotNumericInput = true;
                    switch (sumValue.getType()) {
                        case LONG: {
                            long sum = ((LongValue)this.theValue).getValue();
                            ((LongValue)this.theValue).setValue(sum += ((LongValue)val).getValue());
                            break block0;
                        }
                        case DOUBLE: {
                            double sum = ((DoubleValue)this.theValue).getValue();
                            ((DoubleValue)this.theValue).setValue(sum += (double)((LongValue)val).getValue());
                            break block0;
                        }
                        case NUMBER: {
                            BigDecimal sum = ((NumberValue)this.theValue).getValue();
                            BigDecimal bd = new BigDecimal(((LongValue)val).getValue());
                            sum = sum.add(bd, ctx);
                            ((NumberValue)this.theValue).setValue(sum);
                            break block0;
                        }
                    }
                    assert (false);
                    break;
                }
                case DOUBLE: {
                    this.theGotNumericInput = true;
                    switch (sumValue.getType()) {
                        case LONG: {
                            double sum = ((LongValue)this.theValue).getValue();
                            sum += ((DoubleValue)val).getValue();
                            if (countMemory) {
                                sz = sumValue.sizeof();
                            }
                            sumValue = new DoubleValue(sum);
                            this.theValue = sumValue;
                            if (!countMemory) break block0;
                            rcb.incMemoryConsumption(sumValue.sizeof() - sz);
                            break block0;
                        }
                        case DOUBLE: {
                            double sum = ((DoubleValue)this.theValue).getValue();
                            ((DoubleValue)this.theValue).setValue(sum += ((DoubleValue)val).getValue());
                            break block0;
                        }
                        case NUMBER: {
                            BigDecimal sum = ((NumberValue)this.theValue).getValue();
                            BigDecimal bd = new BigDecimal(((DoubleValue)val).getValue());
                            sum = sum.add(bd, ctx);
                            ((NumberValue)this.theValue).setValue(sum);
                            break block0;
                        }
                    }
                    assert (false);
                    break;
                }
                case NUMBER: {
                    this.theGotNumericInput = true;
                    switch (sumValue.getType()) {
                        case LONG: {
                            BigDecimal sum = new BigDecimal(((LongValue)this.theValue).getValue());
                            sum = sum.add(((NumberValue)val).getValue(), ctx);
                            if (countMemory) {
                                sz = sumValue.sizeof();
                            }
                            sumValue = new NumberValue(sum);
                            this.theValue = sumValue;
                            if (!countMemory) break block0;
                            rcb.incMemoryConsumption(sumValue.sizeof() - sz);
                            break block0;
                        }
                        case DOUBLE: {
                            BigDecimal sum = new BigDecimal(((DoubleValue)this.theValue).getValue());
                            sum = sum.add(((NumberValue)val).getValue(), ctx);
                            if (countMemory) {
                                sz = sumValue.sizeof();
                            }
                            sumValue = new NumberValue(sum);
                            this.theValue = sumValue;
                            if (!countMemory) break block0;
                            rcb.incMemoryConsumption(sumValue.sizeof() - sz);
                            break block0;
                        }
                        case NUMBER: {
                            BigDecimal sum = ((NumberValue)this.theValue).getValue();
                            sum = sum.add(((NumberValue)val).getValue(), ctx);
                            ((NumberValue)this.theValue).setValue(sum);
                            break block0;
                        }
                    }
                    assert (false);
                    break;
                }
            }
        }
    }

    private static class GroupTuple {
        FieldValue[] theValues;

        GroupTuple(int numGBColumns) {
            this.theValues = new FieldValue[numGBColumns];
        }

        public boolean equals(Object other) {
            GroupTuple o = (GroupTuple)other;
            for (int i = 0; i < this.theValues.length; ++i) {
                if (Compare.equal(this.theValues[i], o.theValues[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int code = 1;
            for (int i = 0; i < this.theValues.length; ++i) {
                code += 31 * code + Compare.hashcode(this.theValues[i]);
            }
            return code;
        }

        long sizeof() {
            long size = SizeOf.OBJECT_OVERHEAD + SizeOf.ARRAY_OVERHEAD + (this.theValues.length + 1) * SizeOf.OBJECT_REF_OVERHEAD;
            for (FieldValue val : this.theValues) {
                size += val.sizeof();
            }
            return size;
        }
    }
}

