/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import oracle.nosql.driver.query.ArithOpIter;
import oracle.nosql.driver.query.ConstIter;
import oracle.nosql.driver.query.ExternalVarRefIter;
import oracle.nosql.driver.query.FieldStepIter;
import oracle.nosql.driver.query.FuncCollectIter;
import oracle.nosql.driver.query.FuncMinMaxIter;
import oracle.nosql.driver.query.FuncSizeIter;
import oracle.nosql.driver.query.FuncSumIter;
import oracle.nosql.driver.query.GroupIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryException;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.QueryStateException;
import oracle.nosql.driver.query.ReceiveIter;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.query.SFWIter;
import oracle.nosql.driver.query.SortIter;
import oracle.nosql.driver.query.SortSpec;
import oracle.nosql.driver.query.VarRefIter;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.SerializationUtil;
import oracle.nosql.driver.values.FieldValue;

public abstract class PlanIter {
    static boolean theTraceDeser = false;
    final int theResultReg;
    final int theStatePos;
    final QueryException.Location theLocation;

    protected PlanIter(ByteInputStream in, short serialVersion) throws IOException {
        this.theResultReg = PlanIter.readPositiveInt(in, true);
        this.theStatePos = PlanIter.readPositiveInt(in);
        this.theLocation = new QueryException.Location(PlanIter.readPositiveInt(in), PlanIter.readPositiveInt(in), PlanIter.readPositiveInt(in), PlanIter.readPositiveInt(in));
    }

    public final int getResultReg() {
        return this.theResultReg;
    }

    public QueryException.Location getLocation() {
        return this.theLocation;
    }

    PlanIterState getState(RuntimeControlBlock rcb) {
        return rcb.getState(this.theStatePos);
    }

    public abstract PlanIterKind getKind();

    PlanIter getInputIter() {
        throw new QueryStateException("Method not implemented for iterator " + (Object)((Object)this.getKind()));
    }

    FieldValue getAggrValue(RuntimeControlBlock rcb, boolean reset) {
        throw new QueryStateException("Method not implemented for iterator " + (Object)((Object)this.getKind()));
    }

    public abstract void open(RuntimeControlBlock var1);

    public abstract boolean next(RuntimeControlBlock var1);

    public abstract void reset(RuntimeControlBlock var1);

    public abstract void close(RuntimeControlBlock var1);

    public boolean isDone(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        return state.isDone() || state.isClosed();
    }

    public final String display() {
        StringBuilder sb = new StringBuilder();
        this.display(sb, new QueryFormatter());
        return sb.toString();
    }

    FuncCode getFuncCode() {
        return null;
    }

    void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        this.displayName(sb);
        this.displayRegs(sb);
        sb.append("\n");
        formatter.indent(sb);
        sb.append("[\n");
        formatter.incIndent();
        this.displayContent(sb, formatter);
        formatter.decIndent();
        sb.append("\n");
        formatter.indent(sb);
        sb.append("]");
    }

    void displayName(StringBuilder sb) {
        if (this.getFuncCode() != null) {
            sb.append((Object)this.getFuncCode());
        } else {
            sb.append((Object)this.getKind());
        }
    }

    final void displayRegs(StringBuilder sb) {
        sb.append("(");
        sb.append("[").append(this.theResultReg).append("]");
        sb.append(")");
    }

    protected abstract void displayContent(StringBuilder var1, QueryFormatter var2);

    public static PlanIter deserializeIter(ByteInputStream in, short serialVersion) throws IOException {
        byte ord = in.readByte();
        if (ord == -1) {
            return null;
        }
        PlanIterKind kind = PlanIterKind.valueOf(ord);
        if (theTraceDeser) {
            System.out.println("Deserializing " + (Object)((Object)kind) + " iter");
        }
        PlanIter iter = null;
        switch (kind) {
            case SORT: 
            case SORT2: {
                iter = new SortIter(in, kind, serialVersion);
                break;
            }
            case GROUP: {
                iter = new GroupIter(in, serialVersion);
                break;
            }
            case SFW: {
                iter = new SFWIter(in, serialVersion);
                break;
            }
            case RECV: {
                iter = new ReceiveIter(in, serialVersion);
                break;
            }
            case CONST: {
                iter = new ConstIter(in, serialVersion);
                break;
            }
            case VAR_REF: {
                iter = new VarRefIter(in, serialVersion);
                break;
            }
            case EXTERNAL_VAR_REF: {
                iter = new ExternalVarRefIter(in, serialVersion);
                break;
            }
            case FIELD_STEP: {
                iter = new FieldStepIter(in, serialVersion);
                break;
            }
            case ARITH_OP: {
                iter = new ArithOpIter(in, serialVersion);
                break;
            }
            case FN_SIZE: {
                iter = new FuncSizeIter(in, serialVersion);
                break;
            }
            case FN_SUM: {
                iter = new FuncSumIter(in, serialVersion);
                break;
            }
            case FN_MIN_MAX: {
                iter = new FuncMinMaxIter(in, serialVersion);
                break;
            }
            case FN_COLLECT: {
                iter = new FuncCollectIter(in, serialVersion);
                break;
            }
            default: {
                throw new QueryStateException("Unknown query iterator kind: " + (Object)((Object)kind));
            }
        }
        if (theTraceDeser) {
            System.out.println("Done Deserializing " + (Object)((Object)kind) + " iter");
        }
        return iter;
    }

    static PlanIter[] deserializeIters(ByteInputStream in, short serialVersion) throws IOException {
        int numArgs = SerializationUtil.readSequenceLength(in);
        PlanIter[] iters = new PlanIter[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            iters[i] = PlanIter.deserializeIter(in, serialVersion);
        }
        return iters;
    }

    static int readPositiveInt(ByteInputStream in) throws IOException {
        return PlanIter.readPositiveInt(in, false);
    }

    static int readPositiveInt(ByteInputStream in, boolean allowNegOne) throws IOException {
        int value = in.readInt();
        PlanIter.checkPositiveInt(value, allowNegOne);
        return value;
    }

    private static void checkPositiveInt(int value, boolean allowNegOne) {
        if (allowNegOne) {
            if (value < -1) {
                throw new IllegalArgumentException(value + " is invalid, it must be a positive value or -1");
            }
        } else if (value < 0) {
            throw new IllegalArgumentException(value + " is invalid, it must be a positive value");
        }
    }

    static short readOrdinal(ByteInputStream in, int numValues) throws IOException {
        short index = in.readShort();
        if (index < 0 || index >= numValues) {
            throw new IllegalArgumentException(index + " is invalid, it must be in a range 0 ~ " + numValues);
        }
        return index;
    }

    static SortSpec[] readSortSpecs(ByteInputStream in) throws IOException {
        int len = SerializationUtil.readSequenceLength(in);
        if (len == -1) {
            return null;
        }
        SortSpec[] specs = new SortSpec[len];
        for (int i = 0; i < len; ++i) {
            specs[i] = new SortSpec(in);
        }
        return specs;
    }

    public static String printByteArray(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (byte b : bytes) {
            sb.append(b).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String printIntArray(int[] ints) {
        if (ints == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[ ");
        for (int i = 0; i < ints.length; ++i) {
            int v = ints[i];
            sb.append(v);
            if (i >= ints.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" ]");
        return sb.toString();
    }

    static enum FuncCode {
        OP_ADD_SUB(14),
        OP_MULT_DIV(15),
        FN_COUNT_STAR(42),
        FN_COUNT(43),
        FN_COUNT_NUMBERS(44),
        FN_SUM(45),
        FN_MIN(47),
        FN_MAX(48),
        FN_ARRAY_COLLECT(91),
        FN_ARRAY_COLLECT_DISTINCT(92);

        private static final FuncCode[] VALUES;
        int kvcode;

        private FuncCode(int kvcode) {
            this.kvcode = kvcode;
        }

        public static FuncCode valueOf(int kvcode) {
            for (FuncCode code : VALUES) {
                if (code.kvcode != kvcode) continue;
                return code;
            }
            throw new QueryStateException("Unknown function kind: " + kvcode);
        }

        static {
            VALUES = FuncCode.values();
        }
    }

    public static enum PlanIterKind {
        RECV(17),
        SFW(14),
        SORT(47),
        CONST(0),
        VAR_REF(1),
        EXTERNAL_VAR_REF(2),
        FIELD_STEP(11),
        ARITH_OP(8),
        FN_SIZE(15),
        FN_SUM(39),
        FN_MIN_MAX(41),
        GROUP(65),
        SORT2(66),
        FN_COLLECT(78);

        private static final PlanIterKind[] VALUES;
        int kvcode;

        private PlanIterKind(int kvcode) {
            this.kvcode = kvcode;
        }

        static PlanIterKind valueOf(int kvcode) {
            for (PlanIterKind kind : VALUES) {
                if (kind.kvcode != kvcode) continue;
                return kind;
            }
            return null;
        }

        static {
            VALUES = PlanIterKind.values();
        }
    }
}

